/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class ControllerSetupWizard {
    private final Deque<Stage> stages = new ArrayDeque<Stage>();
    private final List<Screen> screens = new ArrayList<Screen>();

    public void addStage(Supplier<Boolean> enabled, ScreenCreator screenCreator) {
        this.stages.add(new Stage(enabled, screenCreator));
    }

    public void addStage(ScreenCreator screenCreator) {
        this.addStage(() -> true, screenCreator);
    }

    public Screen start(Screen resultantScreen) {
        Screen prevScreen = resultantScreen;
        while (!this.stages.isEmpty()) {
            Screen screen;
            Stage stage = this.stages.pollLast();
            if (!stage.enabled().get().booleanValue() || (screen = stage.screenCreator().createWizardScreen(prevScreen)) == null) continue;
            prevScreen = screen;
            this.screens.add(screen);
        }
        return prevScreen;
    }

    public boolean isDone() {
        Screen screen = Minecraft.getInstance().screen;
        return screen == null || this.screens.stream().noneMatch(resultantScreen -> resultantScreen == screen);
    }

    private record Stage(Supplier<Boolean> enabled, ScreenCreator screenCreator) {
    }

    public static interface ScreenCreator {
        public Screen createWizardScreen(Screen var1);
    }
}

