/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import dev.isxander.controlify.mixins.feature.input.DebugScreenOverlayAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public final class DebugOverlayHelper {
    private static final Minecraft mc = Minecraft.getInstance();

    public static boolean isOverlayEnabled() {
        return ((DebugScreenOverlayAccessor)mc.getDebugOverlay()).isRenderDebug();
    }

    public static void toggleOverlay() {
        mc.getDebugOverlay().toggleOverlay();
    }

    public static void toggleFpsOverlay() {
        mc.getDebugOverlay().toggleFpsCharts();
    }

    public static void toggleNetworkOverlay() {
        mc.getDebugOverlay().toggleNetworkCharts();
    }

    public static void toggleProfilerOverlay() {
        mc.getDebugOverlay().toggleProfilerChart();
    }

    public static void reloadChunks() {
        DebugOverlayHelper.mc.levelRenderer.allChanged();
        DebugOverlayHelper.debugFeedbackTranslated("debug.reload_chunks.message", new Object[0]);
    }

    public static void toggleChunkBorders() {
        boolean flag = DebugOverlayHelper.mc.debugRenderer.switchRenderChunkborder();
        DebugOverlayHelper.debugFeedbackTranslated(flag ? "debug.chunk_boundaries.on" : "debug.chunk_boundaries.off", new Object[0]);
    }

    public static void toggleAdvancedTooltips() {
        DebugOverlayHelper.mc.options.advancedItemTooltips = !DebugOverlayHelper.mc.options.advancedItemTooltips;
        boolean enabled = DebugOverlayHelper.mc.options.advancedItemTooltips;
        DebugOverlayHelper.mc.options.save();
        DebugOverlayHelper.debugFeedbackTranslated(enabled ? "debug.advanced_tooltips.on" : "debug.advanced_tooltips.off", new Object[0]);
    }

    public static void toggleEntityHitboxes() {
        boolean flag = !mc.getEntityRenderDispatcher().shouldRenderHitBoxes();
        mc.getEntityRenderDispatcher().setRenderHitBoxes(flag);
        DebugOverlayHelper.debugFeedbackTranslated(flag ? "debug.show_hitboxes.on" : "debug.show_hitboxes.off", new Object[0]);
    }

    public static void reloadResourcePacks() {
        DebugOverlayHelper.debugFeedbackTranslated("debug.reload_resourcepacks.message", new Object[0]);
        mc.reloadResourcePacks();
    }

    public static void startStopProfiling() {
        if (mc.debugClientMetricsStart(DebugOverlayHelper::debugFeedbackComponent)) {
            DebugOverlayHelper.debugFeedbackTranslated("debug.profiling.start", 10);
        }
    }

    public static void clearChat() {
        DebugOverlayHelper.mc.gui.getChat().clearMessages(false);
    }

    private static void debugComponent(ChatFormatting formatting, Component message) {
        DebugOverlayHelper.mc.gui.getChat().addMessage((Component)Component.empty().append((Component)Component.translatable((String)"debug.prefix").withStyle(new ChatFormatting[]{formatting, ChatFormatting.BOLD})).append(CommonComponents.SPACE).append(message));
    }

    private static void debugFeedbackComponent(Component message) {
        DebugOverlayHelper.debugComponent(ChatFormatting.YELLOW, message);
    }

    private static void debugFeedbackTranslated(String message, Object ... args) {
        DebugOverlayHelper.debugFeedbackComponent((Component)Component.translatable((String)message, (Object[])args));
    }
}

