/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils.animation.impl;

import dev.isxander.controlify.utils.animation.api.Animation;
import dev.isxander.controlify.utils.animation.api.EasingFunction;
import dev.isxander.controlify.utils.animation.impl.Animator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;

public class AnimationImpl
implements Animation {
    private final List<AnimationConsumer> consumers;
    private final List<AnimationDeltaConsumer> deltaConsumers;
    private EasingFunction easing = EasingFunction.LINEAR;
    private float time;
    private int duration;
    private boolean done;

    public AnimationImpl() {
        this.consumers = new ObjectArrayList();
        this.deltaConsumers = new ObjectArrayList();
    }

    public AnimationImpl(AnimationImpl other) {
        this.consumers = new ObjectArrayList(other.consumers);
        this.deltaConsumers = new ObjectArrayList(other.deltaConsumers);
        this.easing = other.easing;
        this.time = other.time;
        this.duration = other.duration;
        this.done = other.done;
    }

    @Override
    public Animation consumerI(Consumer<Integer> consumer, double start, double end) {
        this.consumers.add(new AnimationConsumer(d -> consumer.accept((int)d.doubleValue()), start, end));
        return this;
    }

    @Override
    public Animation consumerF(Consumer<Float> consumer, double start, double end) {
        this.consumers.add(new AnimationConsumer(d -> consumer.accept(Float.valueOf((float)d.doubleValue())), start, end));
        return this;
    }

    @Override
    public Animation consumerD(Consumer<Double> consumer, double start, double end) {
        this.consumers.add(new AnimationConsumer(consumer, start, end));
        return this;
    }

    @Override
    public Animation deltaConsumerI(Consumer<Integer> consumer, double start, double end) {
        this.deltaConsumers.add(new AnimationDeltaConsumer(d -> consumer.accept((int)d.doubleValue()), start, end));
        return this;
    }

    @Override
    public Animation deltaConsumerF(Consumer<Float> consumer, double start, double end) {
        this.deltaConsumers.add(new AnimationDeltaConsumer(d -> consumer.accept(Float.valueOf((float)d.doubleValue())), start, end));
        return this;
    }

    @Override
    public Animation deltaConsumerD(Consumer<Double> consumer, double start, double end) {
        this.deltaConsumers.add(new AnimationDeltaConsumer(consumer, start, end));
        return this;
    }

    @Override
    public Animation duration(int ticks) {
        this.duration = ticks;
        return this;
    }

    @Override
    public Animation easing(EasingFunction easing) {
        this.easing = easing;
        return this;
    }

    @Override
    public Animation copy() {
        return new AnimationImpl(this);
    }

    @Override
    public void tick(float tickDelta) {
        if (this.duration <= 0 || this.time >= (float)this.duration) {
            this.done = true;
        }
        if (this.done) {
            return;
        }
        this.time += tickDelta;
        this.updateConsumers();
    }

    private void updateConsumers() {
        float progress = this.easing.ease(this.time / (float)this.duration);
        this.consumers.forEach(consumer -> consumer.tick(progress));
        this.deltaConsumers.forEach(consumer -> consumer.tick(progress));
    }

    @Override
    public void skipToEnd() {
        this.time = this.duration;
        this.updateConsumers();
        this.done = true;
    }

    @Override
    public void abort() {
        this.done = true;
    }

    @Override
    public Animation play() {
        Animator.INSTANCE.add(this);
        return this;
    }

    @Override
    public boolean hasStarted() {
        return this.time > 0.0f;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isPlaying() {
        return this.hasStarted() && !this.isDone();
    }

    private record AnimationConsumer(Consumer<Double> consumer, double start, double end) {
        public void tick(float tickDelta) {
            this.consumer.accept(this.start + (this.end - this.start) * (double)tickDelta);
        }
    }

    private static class AnimationDeltaConsumer {
        private final Consumer<Double> consumer;
        private final double start;
        private final double end;
        private double lastValue;

        public AnimationDeltaConsumer(Consumer<Double> consumer, double start, double end) {
            this.consumer = consumer;
            this.start = start;
            this.end = end;
        }

        public void tick(float tickDelta) {
            double value = this.start + (this.end - this.start) * (double)tickDelta;
            this.consumer.accept(value - this.lastValue);
            this.lastValue = value;
        }
    }
}

