/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils.log;

import dev.isxander.controlify.utils.log.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public record LogMessage(String message, Object[] args, Throwable throwable, boolean debug, LogLevel level, LocalTime time) {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");

    public LogMessage(String message, Object[] args, Throwable throwable, boolean debug, LogLevel level) {
        this(message, args, throwable, debug, level, LocalTime.now());
    }

    public StringBuilder append(StringBuilder stringBuilder) {
        String expandedString = this.message;
        for (Object arg : this.args) {
            expandedString = expandedString.replaceFirst("\\{}", String.valueOf(arg));
        }
        return stringBuilder.append('[').append(formatter.format(LocalTime.now())).append(']').append(' ').append(this.level == LogLevel.ERROR ? "[ERROR]" : (this.level == LogLevel.WARN ? "[WARN]" : "")).append(' ').append(expandedString).append((String)(this.throwable != null ? "\n" + LogMessage.getStacktrace(this.throwable) : "")).append("\n");
    }

    private static String getStacktrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)writer, true));
        return writer.toString();
    }
}

