/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils.render.elements;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.isxander.controlify.utils.render.BaseRenderState;
import dev.isxander.controlify.utils.render.CGuiElementRenderState;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public record CircleElementRenderState(BaseRenderState baseState, float originX, float originY, float radius, float thickness, int color, int segments) implements CGuiElementRenderState
{
    @Override
    public void buildVertices(VertexConsumer vertexConsumer, float z) {
        float innerRadius = this.radius - this.thickness;
        for (int i = 0; i < this.segments; ++i) {
            int j = (i + 1) % this.segments;
            float angle = (float)i / (float)this.segments * ((float)Math.PI * 2);
            float nextAngle = (float)j / (float)this.segments * ((float)Math.PI * 2);
            float xi1 = this.originX + Mth.sin((float)angle) * innerRadius;
            float yi1 = this.originY + Mth.cos((float)angle) * innerRadius;
            float xi2 = this.originX + Mth.sin((float)nextAngle) * innerRadius;
            float yi2 = this.originY + Mth.cos((float)nextAngle) * innerRadius;
            float xo1 = this.originX + Mth.sin((float)angle) * this.radius;
            float yo1 = this.originY + Mth.cos((float)angle) * this.radius;
            float xo2 = this.originX + Mth.sin((float)nextAngle) * this.radius;
            float yo2 = this.originY + Mth.cos((float)nextAngle) * this.radius;
            this.add2DVertex(vertexConsumer, xi1, yi1, z).setColor(this.color);
            this.add2DVertex(vertexConsumer, xo1, yo1, z).setColor(this.color);
            this.add2DVertex(vertexConsumer, xo2, yo2, z).setColor(this.color);
            this.add2DVertex(vertexConsumer, xi2, yi2, z).setColor(this.color);
        }
    }

    public static CircleElementRenderState outline(GuiGraphics graphics, float originX, float originY, float radius, float thickness, int color) {
        int minX = Mth.floor((float)(originX - radius));
        int minY = Mth.floor((float)(originY - radius));
        int maxX = Mth.ceil((float)(originX + radius));
        int maxY = Mth.ceil((float)(originY + radius));
        return new CircleElementRenderState(BaseRenderState.create(graphics, null, minX, minY, maxX, maxY), originX, originY, radius, thickness, color, CircleElementRenderState.segmentsForRadius(radius));
    }

    public static CircleElementRenderState filled(GuiGraphics graphics, float originX, float originY, float radius, int color) {
        return CircleElementRenderState.outline(graphics, originX, originY, radius, radius, color);
    }

    private static int segmentsForRadius(float radius) {
        return Mth.ceil((double)(Math.PI * 2 * (double)radius / 4.0));
    }
}

