/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.api.guide;

import dev.isxander.controlify.api.guide.Fact;
import dev.isxander.controlify.api.guide.FactCtx;
import dev.isxander.controlify.api.guide.FactProvider;
import dev.isxander.controlify.api.guide.GuideVerbosity;
import dev.isxander.controlify.gui.guide.GuideDomains;
import dev.isxander.controlify.utils.CUtil;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public final class CommonFacts {
    public static final Fact<FactCtx> VERBOSITY_FULL = CommonFacts.register(CUtil.rl("verbosity_full"), ctx -> ctx.verbosity() == GuideVerbosity.FULL);
    public static final Fact<FactCtx> VERBOSITY_REDUCED_OR_MORE = CommonFacts.register(CUtil.rl("verbosity_reduced_or_more"), ctx -> ctx.verbosity().getLevel() >= GuideVerbosity.REDUCED.getLevel());
    public static final Fact<FactCtx> VERBOSITY_REDUCED_OR_LESS = CommonFacts.register(CUtil.rl("verbosity_reduced_or_less"), ctx -> ctx.verbosity().getLevel() <= GuideVerbosity.REDUCED.getLevel());
    public static final Fact<FactCtx> VERBOSITY_MINIMAL = CommonFacts.register(CUtil.rl("verbosity_minimal"), ctx -> ctx.verbosity() == GuideVerbosity.MINIMAL);

    private CommonFacts() {
    }

    private static Fact<FactCtx> register(ResourceLocation id, FactProvider<FactCtx> provider) {
        Fact<FactCtx> fact = Fact.of(id, provider);
        GuideDomains.IN_GAME.registerFact(fact);
        GuideDomains.CONTAINER.registerFact(fact);
        return fact;
    }

    private static Fact<FactCtx> register(ResourceLocation id) {
        return CommonFacts.register(id, FactProvider.staticProvider(false));
    }

    @ApiStatus.Internal
    public static void registerAll() {
    }
}

