/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.steamdeck;

import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.steamdeck.SteamDeckMode;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.log.ControlifyLogger;
import dev.isxander.deckapi.api.SteamDeck;
import dev.isxander.deckapi.api.SteamDeckException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class SteamDeckUtil {
    private static final ControlifyLogger logger = CUtil.LOGGER.createSubLogger("SteamDeckUtil");
    @Nullable
    private static SteamDeck deckInstance;
    private static boolean triedToLoad;
    public static final boolean IS_STEAM_DECK;
    public static final SteamDeckMode DECK_MODE;
    public static final boolean IS_SANDBOXED;
    public static final ResourceLocation STEAM_DECK_NAMESPACE;

    public static Optional<SteamDeck> getDeckInstance() {
        if (triedToLoad) {
            return Optional.ofNullable(deckInstance);
        }
        triedToLoad = true;
        if (!DECK_MODE.isGamingMode() && DebugProperties.STEAM_DECK_CUSTOM_CEF_URL == null) {
            logger.warn("Device is not a Steam Deck or not in gaming mode, skipping Steam Deck driver initialization.");
            return Optional.empty();
        }
        try {
            String url = DebugProperties.STEAM_DECK_CUSTOM_CEF_URL;
            if (url == null) {
                url = "http://127.0.0.1:8080";
            }
            deckInstance = SteamDeck.create((String)url);
        }
        catch (SteamDeckException e) {
            logger.error("Failed to create SteamDeck instance", e);
            deckInstance = null;
        }
        return Optional.ofNullable(deckInstance);
    }

    private static boolean isHardwareSteamDeck() {
        logger.error("Skipping Steam Deck checks as steamOS has temporarily broken the enhaned driver.");
        return false;
    }

    private static SteamDeckMode getSteamDeckMode() {
        if (IS_STEAM_DECK) {
            String steamDeck = System.getenv("SteamDeck");
            if (steamDeck != null && steamDeck.equals("1")) {
                return SteamDeckMode.GAMING_MODE;
            }
            return SteamDeckMode.DESKTOP_MODE;
        }
        return SteamDeckMode.NOT_STEAM_DECK;
    }

    private static String readFile(String path) {
        try {
            return Files.readString(Paths.get(path, new String[0]));
        }
        catch (IOException e) {
            return null;
        }
    }

    static {
        triedToLoad = false;
        IS_STEAM_DECK = SteamDeckUtil.isHardwareSteamDeck();
        DECK_MODE = SteamDeckUtil.getSteamDeckMode();
        IS_SANDBOXED = "1".equals(System.getenv("container"));
        STEAM_DECK_NAMESPACE = CUtil.rl("steam_deck");
    }
}

