/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.InputBindingBuilderImpl;
import dev.isxander.controlify.bindings.InputBindingImpl;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.bindings.output.KeyMappingEmulationOutput;
import dev.isxander.controlify.controller.ControllerEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlifyBindApiImpl
implements ControlifyBindApi {
    public static final ControlifyBindApiImpl INSTANCE = new ControlifyBindApiImpl();
    private final List<RegistryEntry> bindEntries = new ArrayList<RegistryEntry>();
    private final Map<class_304, List<InputBindingSupplier>> keyMappingCorrelations = new HashMap<class_304, List<InputBindingSupplier>>();
    private boolean locked;

    @Override
    public InputBindingSupplier registerBinding(ControlifyBindApi.RegistryCallback callback) {
        return this.registerBinding(callback, c -> true);
    }

    @Override
    public InputBindingSupplier registerBinding(ControlifyBindApi.RegistryCallback callback, Predicate<ControllerEntity> filter) {
        this.checkLocked();
        InputBindingBuilderImpl builder = new InputBindingBuilderImpl();
        callback.apply(builder);
        Function<ControllerEntity, InputBindingImpl> finaliser = builder::build;
        class_2960 bindId = builder.getIdAndLock();
        this.bindEntries.add(new RegistryEntry(filter, finaliser, builder.getKeyEmulation(), builder.getKeyEmulationToggle(), bindId));
        for (class_304 key : builder.getKeyCorrelations()) {
            this.keyMappingCorrelations.computeIfAbsent(key, k -> new ArrayList()).add(this.createSupplier(bindId));
        }
        return this.createSupplier(bindId);
    }

    @Override
    public List<InputBindingSupplier> getKeyCorrelation(class_304 key) {
        return Optional.ofNullable(this.keyMappingCorrelations.get(key)).orElse(List.of());
    }

    @Override
    public void registerRadialIcon(class_2960 id, RadialIcon icon) {
        this.checkLocked();
        RadialIcons.registerIcon(id, icon);
    }

    @Override
    public void registerBindContext(BindContext context) {
        class_2378.method_10230(BindContext.REGISTRY, (class_2960)context.id(), (Object)context);
    }

    private void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("Registry is locked. Cannot add bind now.");
        }
    }

    public List<InputBinding> provideBindsForController(ControllerEntity controller) {
        ArrayList<InputBinding> bindings = new ArrayList<InputBinding>();
        for (RegistryEntry entry : this.bindEntries) {
            if (!entry.filter().test(controller)) continue;
            InputBindingImpl binding = entry.builder().apply(controller);
            if (entry.emulation() != null) {
                BooleanSupplier emulationToggle = null;
                if (entry.emulationToggle() != null) {
                    emulationToggle = () -> entry.emulationToggle().apply(controller);
                }
                binding.addDigitalOutput(InputBinding.KEY_EMULATION, new KeyMappingEmulationOutput(controller, binding, entry.emulation(), emulationToggle));
            }
            bindings.add(binding);
        }
        return bindings;
    }

    private InputBindingSupplier createSupplier(final class_2960 bindingId) {
        return new InputBindingSupplier(){

            @Override
            @Nullable
            public InputBinding onOrNull(@NotNull ControllerEntity controller) {
                return controller.input().map(input -> input.getBinding(bindingId)).orElse(null);
            }

            @Override
            public class_2960 bindId() {
                return bindingId;
            }
        };
    }

    public void lock() {
        this.locked = true;
    }

    @Override
    public Stream<class_2960> getAllBindIds() {
        return this.bindEntries.stream().map(RegistryEntry::id);
    }

    private record RegistryEntry(Predicate<ControllerEntity> filter, Function<ControllerEntity, InputBindingImpl> builder, class_304 emulation, Function<ControllerEntity, Boolean> emulationToggle, class_2960 id) {
    }
}

