/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.core;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.utils.InitialScreenRegistryDuck;
import dev.isxander.controlify.utils.MouseMinecraftCallNotifier;
import dev.isxander.controlify.utils.animation.impl.Animator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_128;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public abstract class MinecraftMixin
implements InitialScreenRegistryDuck {
    @Shadow
    @Final
    public class_312 field_1729;
    @Shadow
    @Nullable
    public class_437 field_1755;
    @Unique
    private final List<Function<Runnable, class_437>> initialScreenCallbacks = new ArrayList<Function<Runnable, class_437>>();
    @Unique
    private boolean initialScreensHappened = false;

    @Shadow
    public abstract void method_1507(@Nullable class_437 var1);

    @Shadow
    public abstract float method_1534();

    @Shadow
    public abstract void method_1519();

    @Shadow
    public abstract class_128 method_1587(class_128 var1);

    @Unique
    private void emergencySaveAndCrash(class_128 crashReport) {
        class_128 filled = this.method_1587(crashReport);
        this.method_1519();
        class_310.method_1565((class_128)filled);
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MouseHandler;releaseMouse()V")})
    private void notifyInjectionToNotRun(class_437 screen, CallbackInfo ci) {
        ((MouseMinecraftCallNotifier)this.field_1729).imFromMinecraftSetScreen();
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init(Lnet/minecraft/client/Minecraft;II)V", shift=At.Shift.AFTER)})
    private void hideMouseAfterRelease(class_437 screen, CallbackInfo ci) {
        if (ControlifyApi.get().currentInputMode().isController()) {
            Controlify.instance().hideMouse(true, true);
        }
    }

    @Inject(method={"onGameLoadFinished"}, at={@At(value="RETURN")})
    private void initControlifyNow(CallbackInfo ci) {
        try {
            Controlify.instance().initializeControlify();
        }
        catch (Throwable t) {
            class_128 report = class_128.method_560((Throwable)t, (String)"Failed to initialize Controlify");
            this.emergencySaveAndCrash(report);
        }
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MouseHandler;turnPlayer()V")})
    private void doPlayerLook(boolean tick, CallbackInfo ci) {
        Controlify.instance().inGameInputHandler().ifPresent(ih -> ih.processPlayerLook(this.getTickDelta()));
    }

    @Inject(method={"close"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/telemetry/ClientTelemetryManager;close()V", remap=true)}, remap=false)
    private void onMinecraftClose(CallbackInfo ci) {
        Controlify.instance().getControllerManager().ifPresent(ControllerManager::close);
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;render(FJZ)V")})
    private void tickAnimator(boolean tick, CallbackInfo ci) {
        Animator.INSTANCE.tick(this.getTickDelta());
    }

    @Unique
    private float getTickDelta() {
        return this.method_1534();
    }

    @Override
    public void controlify$registerInitialScreen(Function<Runnable, class_437> screenFactory) {
        boolean doNow = this.initialScreensHappened;
        doNow = true;
        if (doNow) {
            class_437 lastScreen = this.field_1755;
            this.method_1507(screenFactory.apply(() -> this.method_1507(lastScreen)));
        } else {
            this.initialScreenCallbacks.add(screenFactory);
        }
    }
}

