/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class FuzzyMapCodec<T>
extends MapCodec<T> {
    private final List<MapCodec<? extends T>> codecs;
    private final Function<T, MapEncoder<? extends T>> encoderGetter;

    public FuzzyMapCodec(List<MapCodec<? extends T>> codecs, Function<T, MapEncoder<? extends T>> encoderGetter) {
        this.codecs = codecs;
        this.encoderGetter = encoderGetter;
    }

    public <T1> DataResult<T> decode(DynamicOps<T1> ops, MapLike<T1> input) {
        for (MapDecoder mapDecoder : this.codecs) {
            DataResult result = mapDecoder.decode(ops, input);
            if (!result.result().isPresent()) continue;
            return result;
        }
        return DataResult.error(() -> "No matching codec found.");
    }

    public <T1> RecordBuilder<T1> encode(T input, DynamicOps<T1> ops, RecordBuilder<T1> prefix) {
        MapEncoder<? extends T> encoder = this.encoderGetter.apply(input);
        return encoder.encode(input, ops, prefix);
    }

    public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
        return this.codecs.stream().flatMap(codec -> codec.keys(ops)).distinct();
    }
}

