/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.guide;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.guide.ActionLocation;
import dev.isxander.controlify.api.guide.Fact;
import dev.isxander.controlify.api.guide.FactCtx;
import dev.isxander.controlify.api.guide.GuideDomainRegistry;
import dev.isxander.controlify.api.guide.Rule;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.font.BindingFontHelper;
import dev.isxander.controlify.gui.guide.PrecomputedLines;
import dev.isxander.controlify.gui.guide.RuleSet;
import dev.isxander.controlify.platform.client.resource.SimpleControlifyReloadListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.lang3.Validate;

public class GuideDomain<T extends FactCtx>
implements GuideDomainRegistry<T>,
SimpleControlifyReloadListener<Preparations> {
    public static final String DIRECTORY = "guides";
    private static final FileToIdConverter converter = FileToIdConverter.json((String)"guides");
    private final ResourceLocation id;
    private final Map<ResourceLocation, Fact<T>> facts = new HashMap<ResourceLocation, Fact<T>>();
    private final List<Rule> dynamicRules = new ArrayList<Rule>();
    private boolean frozen = false;
    private List<Rule> rules;
    private Map<ResourceLocation, Boolean> resolvedFacts;
    private PrecomputedLines leftGuides = PrecomputedLines.EMPTY;
    private PrecomputedLines rightGuides = PrecomputedLines.EMPTY;
    private boolean precomputeInvalid = false;

    public GuideDomain(ResourceLocation id) {
        this.id = id;
    }

    public boolean updateGuides(T context, Font font) {
        Validate.isTrue((boolean)this.frozen, (String)"Cannot update guides before the domain has been frozen", (Object[])new Object[0]);
        if (!this.updateFactResolution(context) && !this.precomputeInvalid) {
            return false;
        }
        this.precomputeInvalid = false;
        PrecomputedLines.Builder leftBuilder = new PrecomputedLines.Builder();
        PrecomputedLines.Builder rightBuilder = new PrecomputedLines.Builder();
        HashSet<ResourceLocation> leftConsumed = new HashSet<ResourceLocation>(this.leftGuides.lines().size() + 5);
        HashSet rightConsumed = new HashSet(this.rightGuides.lines().size() + 5);
        ControllerEntity controller = context.controller();
        for (Rule rule : this.rules) {
            PrecomputedLines.Builder builder;
            InputBinding binding = rule.binding().onOrNull(controller);
            if (binding == null || binding.isUnbound()) continue;
            HashSet<ResourceLocation> consumedBinds = switch (rule.where()) {
                case ActionLocation.LEFT -> {
                    builder = leftBuilder;
                    yield leftConsumed;
                }
                case ActionLocation.RIGHT -> {
                    builder = rightBuilder;
                    yield rightConsumed;
                }
                default -> throw new IllegalStateException("Unexpected action location: " + String.valueOf((Object)rule.where()));
            };
            if (consumedBinds.contains(binding.id())) continue;
            boolean whenPermits = rule.when().stream().allMatch(this.resolvedFacts::get);
            boolean forbidPermits = rule.forbid().stream().noneMatch(this.resolvedFacts::get);
            if (!whenPermits || !forbidPermits) continue;
            consumedBinds.add(binding.id());
            boolean glyphAfter = font.isBidirectional() ^ rule.where() == ActionLocation.RIGHT;
            MutableComponent text = Component.empty().append(glyphAfter ? rule.then() : binding.inputGlyph()).append(" ").append(glyphAfter ? binding.inputGlyph() : rule.then());
            int ruleNameWidth = font.width((FormattedText)rule.then());
            int width = font.width((FormattedText)text);
            int glyphWidth = width - ruleNameWidth;
            int backgroundLeft = glyphAfter ? 0 : glyphWidth;
            int backgroundRight = backgroundLeft + ruleNameWidth;
            int height = BindingFontHelper.getComponentHeight(font, (FormattedText)binding.inputGlyph());
            builder.addLine((Component)text, width, height, backgroundLeft, backgroundRight);
        }
        this.leftGuides = leftBuilder.build();
        this.rightGuides = rightBuilder.build();
        return true;
    }

    private boolean updateFactResolution(T context) {
        Validate.isTrue((boolean)this.frozen, (String)"Cannot update fact resolution before the domain has been frozen", (Object[])new Object[0]);
        boolean changed = false;
        for (Map.Entry<ResourceLocation, Boolean> entry : this.resolvedFacts.entrySet()) {
            ResourceLocation factId = entry.getKey();
            Fact<T> fact = this.facts.get(factId);
            boolean newValue = fact.provider().test(context);
            changed |= newValue != entry.getValue();
            entry.setValue(newValue);
        }
        return changed;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public PrecomputedLines leftGuides() {
        return this.leftGuides;
    }

    public PrecomputedLines rightGuides() {
        return this.rightGuides;
    }

    @Override
    public void registerFact(Fact<? super T> fact) {
        Validate.isTrue((!this.frozen ? 1 : 0) != 0, (String)"Cannot register facts after the domain has been frozen", (Object[])new Object[0]);
        Validate.notNull(fact, (String)"Fact cannot be null", (Object[])new Object[0]);
        Validate.isTrue((!this.facts.containsKey(fact.id()) ? 1 : 0) != 0, (String)"Fact with id %s already exists in domain %s", (Object[])new Object[]{fact.id(), this.id});
        Fact<FactCtx> invariantFact = new Fact<FactCtx>(fact.id(), fact.provider()::test);
        this.facts.put(fact.id(), invariantFact);
    }

    @Override
    public void registerDynamicRule(Rule rule) {
        Validate.isTrue((!this.frozen ? 1 : 0) != 0, (String)"Cannot register dynamic rule after the domain has been frozen", (Object[])new Object[0]);
        Validate.notNull((Object)rule, (String)"Rule cannot be null", (Object[])new Object[0]);
        this.dynamicRules.add(rule);
    }

    public boolean freeze() {
        if (this.frozen) {
            return false;
        }
        this.frozen = true;
        return true;
    }

    public List<Rule> rules() {
        return Collections.unmodifiableList((List)Validate.notNull(this.rules, (String)"Rules have not been loaded yet for domain %s", (Object[])new Object[]{this.id}));
    }

    @Override
    public CompletableFuture<Preparations> load(ResourceManager manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            List resources = manager.getResourceStack(converter.idToFile(this.id));
            ArrayList<RuleSet> ruleSets = new ArrayList<RuleSet>();
            for (Resource resource : resources) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonElement element = JsonParser.parseReader((Reader)reader);
                        DataResult result = RuleSet.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                        RuleSet ruleSet = (RuleSet)result.getOrThrow();
                        ruleSets.add(ruleSet);
                        if (!ruleSet.replace()) continue;
                        break;
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load resource", e);
                }
            }
            List<Rule> rules = ruleSets.stream().flatMap(rs -> rs.rules().stream()).toList();
            return new Preparations(rules);
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Preparations data, ResourceManager manager, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            Validate.isTrue((boolean)this.frozen, (String)"Cannot apply domain before the domain has been frozen", (Object[])new Object[0]);
            int ruleCount = data.rules().size() + this.dynamicRules.size();
            this.resolvedFacts = new HashMap<ResourceLocation, Boolean>(ruleCount * 2);
            for (Rule rule : data.rules()) {
                rule.when().forEach(this::validateFact);
                rule.forbid().forEach(this::validateFact);
            }
            this.rules = new ArrayList<Rule>(ruleCount);
            this.rules.addAll(data.rules());
            this.rules.addAll(this.dynamicRules);
            this.precomputeInvalid = true;
        }, executor);
    }

    private Fact<T> validateFact(ResourceLocation factId) {
        Fact<T> fact = this.facts.get(factId);
        Validate.notNull(fact, (String)"Fact %s is not registered in domain %s", (Object[])new Object[]{factId, this.id});
        this.resolvedFacts.put(factId, false);
        return fact;
    }

    @Override
    public ResourceLocation getReloadId() {
        return this.id.withPrefix("reload/");
    }

    public record Preparations(List<Rule> rules) {
    }
}

