/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.core;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.utils.MouseMinecraftCallNotifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class})
public class MouseHandlerMixin
implements MouseMinecraftCallNotifier {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private boolean controlify$calledFromMinecraftSetScreen = false;

    @WrapOperation(method={"setup"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/InputConstants;setupMouseCallbacks(JLorg/lwjgl/glfw/GLFWCursorPosCallbackI;Lorg/lwjgl/glfw/GLFWMouseButtonCallbackI;Lorg/lwjgl/glfw/GLFWScrollCallbackI;Lorg/lwjgl/glfw/GLFWDropCallbackI;)V")})
    private void wrapMouseEvents(long window, GLFWCursorPosCallbackI moveCallback, GLFWMouseButtonCallbackI buttonCallback, GLFWScrollCallbackI scrollCallback, GLFWDropCallbackI fileDropCallback, Operation<Void> operation) {
        operation.call(new Object[]{window, (w, x, y) -> {
            this.onMouse(w);
            moveCallback.invoke(w, x, y);
        }, (w, b, a, m) -> {
            this.onMouse(w);
            buttonCallback.invoke(w, b, a, m);
        }, (w, dx, dy) -> {
            this.onMouse(w);
            scrollCallback.invoke(w, dx, dy);
        }, fileDropCallback});
    }

    @Unique
    private void onMouse(long window) {
        long windowHandle = this.minecraft.getWindow().getWindow();
        if (window == windowHandle) {
            this.minecraft.execute(() -> {
                if (Controlify.instance().currentInputMode() != InputMode.MIXED) {
                    Controlify.instance().setInputMode(InputMode.KEYBOARD_MOUSE);
                } else {
                    Controlify.instance().showCursorTemporarily();
                }
            });
        }
    }

    @Inject(method={"releaseMouse"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/InputConstants;grabOrReleaseMouse(JIDD)V")})
    private void moveMouseIfNecessary(CallbackInfo ci) {
        if (!this.controlify$calledFromMinecraftSetScreen && ControlifyApi.get().currentInputMode().isController()) {
            Controlify.instance().hideMouse(true, true);
        }
    }

    @Inject(method={"releaseMouse"}, at={@At(value="RETURN")})
    private void resetCalledFromMinecraftSetScreen(CallbackInfo ci) {
        this.controlify$calledFromMinecraftSetScreen = false;
    }

    @ModifyExpressionValue(method={"grabMouse"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;isWindowActive()Z")})
    private boolean passWindowActiveCheckIfOOFInputIsOn(boolean isWindowActive) {
        return isWindowActive || ControlifyApi.get().currentInputMode().isController() && Controlify.instance().config().globalSettings().outOfFocusInput;
    }

    @Override
    public void imFromMinecraftSetScreen() {
        this.controlify$calledFromMinecraftSetScreen = true;
    }
}

