/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.compatibility.rso.mixins;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.controlify.compatibility.rso.mixins.AbstractFrameAccessor;
import dev.isxander.controlify.compatibility.rso.mixins.TabFrameAccessor;
import dev.isxander.controlify.compatibility.sodium.screenop.SodiumGuiScreenProcessor;
import dev.isxander.controlify.compatibility.sodium.screenop.SodiumScreenOperations;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import java.util.List;
import java.util.Optional;
import me.flashyreese.mods.reeses_sodium_options.client.gui.SodiumVideoOptionsScreen;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.Tab;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.TabFrame;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.widgets.FlatButtonWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SodiumVideoOptionsScreen.class})
public abstract class SodiumVideoOptionsScreenMixin
extends Screen
implements ScreenProcessorProvider,
SodiumScreenOperations {
    @Shadow
    private FlatButtonWidget applyButton;
    @Shadow
    private FlatButtonWidget closeButton;
    @Shadow
    private FlatButtonWidget undoButton;
    @Unique
    private final SodiumGuiScreenProcessor controlify$screenProcessor = new SodiumGuiScreenProcessor((Screen)((SodiumVideoOptionsScreen)this), this);
    @Unique
    private TabFrame tabFrame;

    protected SodiumVideoOptionsScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void notifyProcessorRebuild(CallbackInfo ci) {
        this.controlify$screenProcessor.onRebuildGUI();
        this.focusOnFirstControl();
    }

    @ModifyExpressionValue(method={"lambda$parentBasicFrameBuilder$9"}, at={@At(value="INVOKE", target="Lme/flashyreese/mods/reeses_sodium_options/client/gui/frame/tab/TabFrame$Builder;build()Lme/flashyreese/mods/reeses_sodium_options/client/gui/frame/tab/TabFrame;")})
    private TabFrame storeBuiltTabFrame(TabFrame original) {
        this.tabFrame = original;
        return this.tabFrame;
    }

    @ModifyArg(method={"lambda$parentBasicFrameBuilder$9"}, at=@At(value="INVOKE", target="Lme/flashyreese/mods/reeses_sodium_options/client/gui/frame/tab/TabFrame$Builder;onSetTab(Ljava/lang/Runnable;)Lme/flashyreese/mods/reeses_sodium_options/client/gui/frame/tab/TabFrame$Builder;"))
    private Runnable setInitialFocusOnTabChange(Runnable onSetTab) {
        return () -> {
            onSetTab.run();
            Minecraft.getInstance().schedule(this::focusOnFirstControl);
        };
    }

    @Unique
    private void focusOnFirstControl() {
        AbstractFrame tabContentsFrame = ((TabFrameAccessor)this.tabFrame).getSelectedFrame();
        List<ControlElement<?>> controlElements = ((AbstractFrameAccessor)tabContentsFrame).getControlElements();
        if (!controlElements.isEmpty()) {
            System.out.println(controlElements.get(0).getOption().getName().getString());
            this.setInitialFocus((GuiEventListener)controlElements.get(0));
        }
    }

    @Override
    public ScreenProcessor<?> screenProcessor() {
        return this.controlify$screenProcessor;
    }

    @Override
    public void controlify$nextPage() {
        TabFrameAccessor accessor = (TabFrameAccessor)this.tabFrame;
        List<Tab<?>> tabs = accessor.getTabs();
        Optional<Tab<?>> selectedTab = this.getSelectedTab(accessor);
        if (selectedTab.isEmpty()) {
            return;
        }
        int currentIndex = tabs.indexOf(selectedTab.get());
        int nextIndex = (currentIndex + 1) % tabs.size();
        this.tabFrame.setTab(Optional.of(tabs.get(nextIndex)));
    }

    @Override
    public void controlify$prevPage() {
        TabFrameAccessor accessor = (TabFrameAccessor)this.tabFrame;
        List<Tab<?>> tabs = accessor.getTabs();
        Optional<Tab<?>> selectedTab = this.getSelectedTab(accessor);
        if (selectedTab.isEmpty()) {
            return;
        }
        int currentIndex = tabs.indexOf(selectedTab.get());
        int nextIndex = (currentIndex - 1 + tabs.size()) % tabs.size();
        this.tabFrame.setTab(Optional.of(tabs.get(nextIndex)));
    }

    @Override
    public FlatButtonWidget controlify$getApplyButton() {
        return this.applyButton;
    }

    @Override
    public FlatButtonWidget controlify$getCloseButton() {
        return this.closeButton;
    }

    @Override
    public FlatButtonWidget controlify$getUndoButton() {
        return this.undoButton;
    }

    @Unique
    private Optional<Tab<?>> getSelectedTab(TabFrameAccessor accessor) {
        return accessor.getSelectedTab();
    }
}

