/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.patches.analogueboat;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.fixes.boatfix.AnalogBoatInput;
import dev.isxander.controlify.ingame.InGameInputHandler;
import dev.isxander.controlify.utils.MthExt;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.phys.Vec2;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LocalPlayer.class})
public class LocalPlayerMixin {
    @Shadow
    public ClientInput input;

    @WrapOperation(method={"rideTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractBoat;setInput(ZZZZ)V")})
    private void useAnalogInput(AbstractBoat boat, boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack, Operation<Void> original) {
        if (ControlifyApi.get().currentInputMode().isController() && !Controlify.instance().config().globalSettings().shouldUseKeyboardMovement()) {
            Vec2 moveVec = InGameInputHandler.getMoveVec(this.input);
            float forwardImpulse = moveVec.y;
            float rightImpulse = -moveVec.x;
            float deadzone = 0.1f;
            float onlyRightImpulseAbs = Math.max(0.0f, rightImpulse);
            float onlyLeftImpulseAbs = -Math.min(0.0f, rightImpulse);
            onlyRightImpulseAbs = onlyRightImpulseAbs < deadzone ? 0.0f : MthExt.remap(onlyRightImpulseAbs, deadzone, 1.0f, 0.0f, 1.0f);
            onlyLeftImpulseAbs = onlyLeftImpulseAbs < deadzone ? 0.0f : MthExt.remap(onlyLeftImpulseAbs, deadzone, 1.0f, 0.0f, 1.0f);
            rightImpulse = onlyRightImpulseAbs - onlyLeftImpulseAbs;
            ((AnalogBoatInput)boat).controlify$setAnalogInput(forwardImpulse, rightImpulse);
            return;
        }
        original.call(new Object[]{boat, pressingLeft, pressingRight, pressingForward, pressingBack});
    }
}

