/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.keyboard;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.isxander.controlify.platform.client.resource.SimpleControlifyReloadListener;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayout;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayoutWithId;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayouts;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.log.ControlifyLogger;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class KeyboardLayoutManager
implements SimpleControlifyReloadListener<Preparations> {
    private static final String PREFIX = "keyboard_layout";
    private static final ControlifyLogger LOGGER = CUtil.LOGGER.createSubLogger("KeyboardLayoutManager");
    private Map<KeyboardLayoutKey, KeyboardLayout> layouts = Map.of();

    @Override
    public CompletableFuture<Preparations> load(ResourceManager manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> KeyboardLayoutManager.listMatchingResources(manager), executor).thenCompose(layoutMap -> {
            List<CompletableFuture> futures = layoutMap.entrySet().stream().map(entry -> this.loadLayout((ResourceLocation)entry.getKey(), (Resource)entry.getValue(), executor)).toList();
            CompletionStage map = Util.sequence(futures).thenApply(listOfEntries -> listOfEntries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a)));
            return ((CompletableFuture)map).thenApply(Preparations::new);
        });
    }

    private CompletableFuture<Map.Entry<KeyboardLayoutKey, KeyboardLayout>> loadLayout(ResourceLocation file, Resource resource, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            Map.Entry<KeyboardLayoutKey, KeyboardLayout> entry;
            block8: {
                KeyboardLayoutKey key = KeyboardLayoutManager.fileToKey(file);
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    KeyboardLayout layout = (KeyboardLayout)KeyboardLayout.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(reason -> new RuntimeException("Failed to parse keyboard layout " + String.valueOf(key) + ": " + reason));
                    entry = Map.entry(key, layout);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to read keyboard layout " + String.valueOf(key) + ": " + e.getMessage(), e);
                    }
                }
                reader.close();
            }
            return entry;
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Preparations data, ResourceManager manager, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            this.layouts = data.layouts();
            LOGGER.log("Loaded {} keyboard layouts", this.layouts.size());
        }, executor);
    }

    public KeyboardLayoutWithId getLayout(ResourceLocation layoutId, String languageCode) {
        KeyboardLayoutKey key = new KeyboardLayoutKey(languageCode, layoutId);
        return Optional.ofNullable(this.layouts.get(key)).or(() -> Optional.ofNullable(this.layouts.get(key.withDefaultLanguage()))).map(layout -> new KeyboardLayoutWithId((KeyboardLayout)layout, layoutId)).orElse(KeyboardLayouts.fallback());
    }

    public KeyboardLayoutWithId getLayout(ResourceLocation layout) {
        String currentLanguage = Minecraft.getInstance().getLanguageManager().getSelected();
        return this.getLayout(layout, currentLanguage);
    }

    @Override
    public ResourceLocation getReloadId() {
        return CUtil.rl(PREFIX);
    }

    private static ResourceLocation keyToFile(KeyboardLayoutKey key) {
        return key.layoutId().withPath("keyboard_layout/" + key.layoutId().getPath() + "/" + key.languageCode() + ".json");
    }

    private static KeyboardLayoutKey fileToKey(ResourceLocation file) {
        try {
            String[] components = file.getPath().split("/");
            String layoutPath = components[1];
            String languageCodeWithExt = components[2];
            String languageCode = languageCodeWithExt.substring(0, languageCodeWithExt.lastIndexOf(46));
            ResourceLocation layoutId = file.withPath(layoutPath);
            return new KeyboardLayoutKey(languageCode, layoutId);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid file path. Expected format: keyboard_layout/<layout_id>/<language_code>.json, but got " + file.getPath(), e);
        }
    }

    private static Map<ResourceLocation, Resource> listMatchingResources(ResourceManager resourceManager) {
        return resourceManager.listResources(PREFIX, path -> path.getPath().endsWith(".json"));
    }

    public record Preparations(Map<KeyboardLayoutKey, KeyboardLayout> layouts) {
    }

    private record KeyboardLayoutKey(String languageCode, ResourceLocation layoutId) {
        public static final String DEFAULT_LANGUAGE = "en_us";

        public KeyboardLayoutKey withLanguage(String languageCode) {
            return new KeyboardLayoutKey(languageCode, this.layoutId);
        }

        public KeyboardLayoutKey withDefaultLanguage() {
            return new KeyboardLayoutKey(DEFAULT_LANGUAGE, this.layoutId);
        }
    }
}

