/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.api.bind;

import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.StateAccess;
import dev.isxander.controlify.bindings.input.EmptyInput;
import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.bindings.output.AnalogueOutput;
import dev.isxander.controlify.bindings.output.DigitalOutput;
import dev.isxander.controlify.bindings.output.GuiPressOutput;
import dev.isxander.controlify.controller.input.ControllerStateView;
import dev.isxander.controlify.utils.CUtil;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public interface InputBinding {
    public static final ResourceLocation ANALOGUE_NOW = CUtil.rl("analogue_now");
    public static final ResourceLocation ANALOGUE_PREV = CUtil.rl("analogue_prev");
    public static final ResourceLocation DIGITAL_NOW = CUtil.rl("digital_now");
    public static final ResourceLocation DIGITAL_PREV = CUtil.rl("digital_prev");
    public static final ResourceLocation JUST_PRESSED = CUtil.rl("just_pressed");
    public static final ResourceLocation JUST_RELEASED = CUtil.rl("just_released");
    public static final ResourceLocation JUST_TAPPED = CUtil.rl("just_tapped");
    public static final ResourceLocation GUI_PRESSED = CUtil.rl("gui_pressed");
    public static final ResourceLocation KEY_EMULATION = CUtil.rl("key_emulation");

    public ResourceLocation id();

    public Component name();

    public Component description();

    public Component category();

    public Component inputIcon();

    public StateAccess createStateAccess(int var1);

    public StateAccess createStateAccess(int var1, Consumer<StateAccess> var2);

    public void returnStateAccess(StateAccess var1);

    @ApiStatus.Internal
    public void pushState(ControllerStateView var1);

    public void fakePress();

    public void setBoundInput(Input var1);

    public Input boundInput();

    public Input defaultInput();

    default public boolean isUnbound() {
        return EmptyInput.equals(this.boundInput());
    }

    public Set<BindContext> contexts();

    public Optional<ResourceLocation> radialIcon();

    public float analogueNow();

    public float analoguePrev();

    public boolean digitalNow();

    public boolean digitalPrev();

    public boolean justPressed();

    public boolean justReleased();

    public boolean justTapped();

    public GuiPressOutput guiPressed();

    public <T extends DigitalOutput> T getDigitalOutput(ResourceLocation var1);

    public <T extends DigitalOutput> T addDigitalOutput(ResourceLocation var1, T var2);

    public <T extends AnalogueOutput> T getAnalogueOutput(ResourceLocation var1);

    public <T extends AnalogueOutput> T addAnalogueOutput(ResourceLocation var1, T var2);
}

