/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.render.Blit;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class RadialIcons {
    private static final Minecraft minecraft = Minecraft.getInstance();
    public static final ResourceLocation EMPTY = CUtil.rl("empty");
    public static final ResourceLocation FABRIC_ICON = CUtil.rl("fabric-resource-loader-v0", "icon.png");
    private static Map<ResourceLocation, RadialIcon> icons = null;
    private static Queue<Runnable> deferredRegistrations = new ArrayDeque<Runnable>();

    public static Map<ResourceLocation, RadialIcon> getIcons() {
        if (icons == null) {
            icons = RadialIcons.registerIcons();
            deferredRegistrations.forEach(Runnable::run);
            deferredRegistrations = null;
        }
        return icons;
    }

    public static void registerIcon(ResourceLocation location, RadialIcon icon) {
        if (icons == null) {
            deferredRegistrations.add(() -> RadialIcons.registerIcon(location, icon));
            return;
        }
        icons.put(location, icon);
    }

    public static ResourceLocation getItem(Item item) {
        return RadialIcons.prefixLocation("item", BuiltInRegistries.ITEM.getKey((Object)item));
    }

    public static ResourceLocation getEffect(Holder<MobEffect> effectHolder) {
        MobEffect effect = (MobEffect)effectHolder.value();
        return RadialIcons.prefixLocation("effect", BuiltInRegistries.MOB_EFFECT.getKey((Object)effect));
    }

    private static void addItems(Map<ResourceLocation, RadialIcon> map) {
        BuiltInRegistries.ITEM.entrySet().forEach(entry -> {
            ResourceKey key = (ResourceKey)entry.getKey();
            ItemStack stack = ((Item)entry.getValue()).getDefaultInstance();
            map.put(RadialIcons.prefixLocation("item", key.location()), (graphics, x, y, tickDelta) -> graphics.renderItem(stack, x, y));
        });
    }

    private static void addPotionEffects(Map<ResourceLocation, RadialIcon> map) {
        MobEffectTextureManager mobEffectTextureManager = minecraft.getMobEffectTextures();
        BuiltInRegistries.MOB_EFFECT.entrySet().forEach(entry -> {
            ResourceKey key = (ResourceKey)entry.getKey();
            Holder effect = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)entry.getValue()));
            TextureAtlasSprite sprite = mobEffectTextureManager.get(effect);
            if (sprite != null) {
                map.put(RadialIcons.prefixLocation("effect", key.location()), (graphics, x, y, tickDelta) -> {
                    if (sprite.atlasLocation() != null) {
                        graphics.pose().pushPose();
                        graphics.pose().translate((float)x, (float)y, 0.0f);
                        graphics.pose().scale(0.88f, 0.88f, 1.0f);
                        Blit.blitSprite(graphics, sprite, 0, 0, 18, 18, -1);
                        graphics.pose().popPose();
                    }
                });
            }
        });
    }

    private static ResourceLocation prefixLocation(String prefix, ResourceLocation location) {
        return CUtil.rl(location.getNamespace(), prefix + "/" + location.getPath());
    }

    private static Map<ResourceLocation, RadialIcon> registerIcons() {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        map.put(EMPTY, (graphics, x, y, tickDelta) -> {});
        map.put(FABRIC_ICON, (graphics, x, y, tickDelta) -> {
            graphics.pose().pushPose();
            graphics.pose().translate((float)x, (float)y, 0.0f);
            graphics.pose().scale(0.5f, 0.5f, 1.0f);
            Blit.blitTex(graphics, FABRIC_ICON, 0, 0, 0, 0, 32, 32, 32, 32);
            graphics.pose().popPose();
        });
        RadialIcons.addItems((Map<ResourceLocation, RadialIcon>)map);
        RadialIcons.addPotionEffects((Map<ResourceLocation, RadialIcon>)map);
        return map;
    }
}

