/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver;

import com.google.common.collect.Lists;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.driver.Driver;
import java.util.List;
import java.util.stream.Collectors;

public class CompoundDriver
implements Driver {
    private final List<Driver> drivers;

    public CompoundDriver(List<Driver> drivers) {
        this.drivers = drivers;
    }

    @Override
    public void addComponents(ControllerEntity controller) {
        for (Driver driver : Lists.reverse(this.drivers)) {
            driver.addComponents(controller);
        }
    }

    @Override
    public void update(ControllerEntity controller, boolean outOfFocus) {
        for (Driver driver : this.drivers) {
            driver.update(controller, outOfFocus);
        }
    }

    @Override
    public void close() {
        for (Driver driver : this.drivers) {
            driver.close();
        }
    }

    public String toString() {
        return "CompoundDriver{" + this.drivers.stream().map(d -> d.getClass().getSimpleName()).collect(Collectors.joining(",")) + "}";
    }
}

