/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.guide;

import dev.isxander.controlify.font.BindingFontHelper;
import dev.isxander.controlify.gui.guide.GuideAction;
import dev.isxander.controlify.gui.layout.RenderComponent;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class GuideActionRenderer<T>
implements RenderComponent {
    private final GuideAction<T> guideAction;
    private final boolean rtl;
    private final boolean textContrast;
    private Component bindingText;
    private int bindingTextWidth;
    private Component name = null;

    public GuideActionRenderer(GuideAction<T> action, boolean rtl, boolean textContrast) {
        this.guideAction = action;
        this.rtl = rtl;
        this.textContrast = textContrast;
        this.bindingText = action.binding().inputIcon();
        this.bindingTextWidth = Minecraft.getInstance().font.width((FormattedText)this.bindingText);
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float deltaTime) {
        if (!this.isVisible()) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width((FormattedText)this.name);
        int bindingHeight = BindingFontHelper.getComponentHeight(font, (FormattedText)this.bindingText);
        int n = y + bindingHeight / 2;
        Objects.requireNonNull(font);
        int centeredTextY = n - 9 / 2;
        if (!this.rtl) {
            graphics.drawString(font, this.bindingText, x, centeredTextY, -1, false);
            x += this.bindingTextWidth + 4;
        }
        if (this.textContrast) {
            Objects.requireNonNull(font);
            graphics.fill(x - 1, centeredTextY - 1, x + textWidth + 1, centeredTextY + 9 + 1, Integer.MIN_VALUE);
        }
        graphics.drawString(font, this.name, x, centeredTextY, -1, false);
        x += textWidth + 4;
        if (this.rtl) {
            graphics.drawString(font, this.bindingText, x, centeredTextY, -1, false);
        }
    }

    @Override
    public Vector2ic size() {
        if (!this.isVisible()) {
            return new Vector2i();
        }
        Font font = Minecraft.getInstance().font;
        int n = font.width((FormattedText)this.name) + 4 + this.bindingTextWidth;
        int n2 = BindingFontHelper.getComponentHeight(font, (FormattedText)this.bindingText);
        Objects.requireNonNull(font);
        return new Vector2i(n, Math.max(n2, 9) + 2);
    }

    @Override
    public boolean isVisible() {
        return this.name != null && !this.guideAction.binding().isUnbound() && this.bindingText != null;
    }

    public void updateName(T ctx) {
        this.bindingText = this.guideAction.binding().inputIcon();
        this.bindingTextWidth = Minecraft.getInstance().font.width((FormattedText)this.bindingText);
        this.name = this.guideAction.name().supply(ctx).orElse(null);
    }
}

