/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.GenericControllerConfig;
import dev.isxander.controlify.controller.steamdeck.SteamDeckComponent;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.gui.components.FakePositionPlainTextButton;
import dev.isxander.controlify.gui.screen.ControllerConfigScreenFactory;
import dev.isxander.controlify.gui.screen.GlobalSettingsScreenFactory;
import dev.isxander.controlify.mixins.feature.ui.AbstractSelectionListAccessor;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ClientUtils;
import dev.isxander.controlify.utils.ColorUtils;
import dev.isxander.controlify.utils.animation.api.Animatable;
import dev.isxander.controlify.utils.animation.api.Animation;
import dev.isxander.controlify.utils.animation.api.EasingFunction;
import dev.isxander.controlify.utils.render.Blit;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerCarouselScreen
extends Screen
implements ScreenControllerEventListener {
    public static final ResourceLocation CHECKMARK = CUtil.mcRl("icon/checkmark");
    public static final ResourceLocation DANGER = CUtil.mcRl("icon/unseen_notification");
    private final Screen parent;
    private int footerY;
    private List<CarouselEntry> carouselEntries = null;
    private int carouselIndex;
    private Animatable carouselAnimation = null;
    private final Controlify controlify;
    private final ControllerManager controllerManager;
    private Button globalSettingsButton;
    private Button unbindControllerButton;
    private Button doneButton;
    private Button controllerNotDetectedButton;

    private ControllerCarouselScreen(Screen parent) {
        super((Component)Component.translatable((String)"controlify.gui.carousel.title"));
        this.parent = parent;
        this.controlify = Controlify.instance();
        this.controllerManager = this.controlify.getControllerManager().orElseThrow();
        this.carouselIndex = this.controlify.getCurrentController().map(c -> this.controllerManager.getConnectedControllers().indexOf(c)).orElse(0);
    }

    public static void openConfigScreen(Screen parent) {
        Controlify controlify = Controlify.instance();
        controlify.finishControlifyInit().whenComplete((v, th) -> Minecraft.getInstance().setScreen((Screen)new ControllerCarouselScreen(parent)));
    }

    protected void init() {
        this.refreshControllers();
        MutableComponent donateText = Component.translatable((String)"controlify.gui.carousel.donate").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
        FakePositionPlainTextButton donateBtn = (FakePositionPlainTextButton)this.addRenderableWidget((GuiEventListener)new FakePositionPlainTextButton((Component)donateText, this.font, 3, 3, btn -> Util.getPlatform().openUri("https://ko-fi.com/isxander")));
        donateBtn.setFakePosition(new ScreenRectangle(0, this.height, this.width, 1));
        MutableComponent artCreditText = Component.translatable((String)"controlify.gui.carousel.art_credit", (Object[])new Object[]{Component.literal((String)"Andrew Grant")}).withStyle(ChatFormatting.DARK_GRAY);
        FakePositionPlainTextButton artCreditBtn = (FakePositionPlainTextButton)this.addRenderableWidget((GuiEventListener)new FakePositionPlainTextButton((Component)artCreditText, this.font, this.width - this.font.width((FormattedText)artCreditText) - 3, 3, btn -> Util.getPlatform().openUri("https://github.com/Andrew6rant")));
        artCreditBtn.setFakePosition(new ScreenRectangle(0, this.height + 1, this.width, 1));
        GridLayout grid = new GridLayout().columnSpacing(10);
        GridLayout.RowHelper rowHelper = grid.createRowHelper(2);
        this.globalSettingsButton = (Button)rowHelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"controlify.gui.global_settings.title"), btn -> this.minecraft.setScreen(GlobalSettingsScreenFactory.createGlobalSettingsScreen(this))).build());
        this.doneButton = (Button)rowHelper.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onClose()).build());
        grid.visitWidgets(widget -> {
            widget.setTabOrderGroup(1);
            this.addRenderableWidget((GuiEventListener)widget);
        });
        grid.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)grid, (int)0, (int)(this.height - 36), (int)this.width, (int)36);
        this.controllerNotDetectedButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"controlify.gui.carousel.controller_not_detected_btn"), btn -> Util.getPlatform().openUri("https://docs.isxander.dev/controlify/users/controller-issues#my-controller-is-not-detected")).pos(this.width / 2 - 75, (this.height - 36) / 2 + 10).tooltip(Tooltip.create((Component)Component.translatable((String)"controlify.gui.carousel.controller_not_detected_btn.tooltip"))).build());
        this.controllerNotDetectedButton.visible = this.carouselEntries.isEmpty();
        ButtonGuideApi.addGuideToButton(this.globalSettingsButton, ControlifyBindings.GUI_ABSTRACT_ACTION_1, ButtonGuidePredicate.always());
        ButtonGuideApi.addGuideToButton(this.doneButton, ControlifyBindings.GUI_BACK, ButtonGuidePredicate.always());
        this.footerY = Mth.roundToward((int)(this.height - 36 - 2), (int)2);
    }

    public void refreshControllers() {
        ControllerEntity prevSelectedController;
        if (this.carouselEntries != null && !this.carouselEntries.isEmpty()) {
            this.carouselEntries.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
            prevSelectedController = this.carouselEntries.get((int)this.carouselIndex).controller;
        } else {
            prevSelectedController = null;
        }
        this.carouselEntries = this.controllerManager.getConnectedControllers().stream().map(c -> new CarouselEntry((ControllerEntity)c, this.width / 3, this.height - 66)).peek(x$0 -> {
            CarouselEntry cfr_ignored_0 = (CarouselEntry)this.addRenderableWidget((GuiEventListener)x$0);
        }).toList();
        this.carouselIndex = this.carouselEntries.stream().filter(e -> e.controller == prevSelectedController).findFirst().map(this.carouselEntries::indexOf).orElse(Controlify.instance().getCurrentController().map(c -> this.controllerManager.getConnectedControllers().indexOf(c)).orElse(0));
        if (!this.carouselEntries.isEmpty()) {
            this.carouselEntries.get((int)this.carouselIndex).overlayColor = 0;
        }
        float offsetX = (float)this.width / 2.0f * (float)(-(this.carouselIndex - 1)) - (float)this.width / 6.0f;
        for (int i = 0; i < this.carouselEntries.size(); ++i) {
            CarouselEntry entry = this.carouselEntries.get(i);
            entry.setX(offsetX + (float)this.width / 2.0f * (float)i);
            entry.setY(i == this.carouselIndex ? 20.0f : 10.0f);
        }
        if (this.controllerNotDetectedButton != null) {
            this.controllerNotDetectedButton.visible = this.carouselEntries.isEmpty();
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        Blit.blitTex(graphics, this.minecraft.level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR, 0, this.footerY, 0.0f, 0.0f, this.width, 2, 32, 2);
        if (this.carouselEntries.isEmpty()) {
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"controlify.gui.carousel.no_controllers"), this.width / 2, (this.height - 36) / 2 - 10, -5592406);
        }
    }

    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
        super.renderBackground(graphics, i, j, f);
        Blit.blitTex(graphics, this.minecraft.level == null ? AbstractSelectionListAccessor.getMenuListBackground() : AbstractSelectionListAccessor.getInWorldMenuListBackground(), 0, 0, 0.0f, 0.0f, this.width, this.footerY, 32, 32);
    }

    public void focusOnEntry(int index) {
        if (this.carouselAnimation != null && !this.carouselAnimation.isDone()) {
            return;
        }
        int diff = index - this.carouselIndex;
        if (diff == 0) {
            return;
        }
        this.carouselIndex = index;
        Animation animation = Animation.of(10).easing(EasingFunction.EASE_IN_OUT_CUBIC);
        for (CarouselEntry entry : this.carouselEntries) {
            boolean selected = this.carouselEntries.indexOf((Object)entry) == index;
            animation.consumerF(entry::setX, entry.getX(), (float)entry.getX() + (float)(-diff) * ((float)this.width / 2.0f));
            animation.consumerF(entry::setY, entry.getY(), selected ? 20.0 : 10.0);
            animation.consumerF(t -> {
                entry.overlayColor = ColorUtils.lerpARGB(t.floatValue(), entry.overlayColor, selected ? 0 : -1879048192);
            }, 0.0, 1.0);
        }
        this.carouselAnimation = animation.play();
    }

    @Override
    public void onControllerInput(ControllerEntity controller) {
        if (ControlifyBindings.GUI_ABSTRACT_ACTION_1.on(controller).justPressed()) {
            this.globalSettingsButton.onPress();
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    private class CarouselEntry
    extends AbstractContainerEventHandler
    implements Renderable,
    NarratableEntry {
        private int x;
        private int y;
        private final int width;
        private final int height;
        private float translationX;
        private float translationY;
        private final ControllerEntity controller;
        private final boolean hasNickname;
        private final Button useControllerButton;
        private final Button settingsButton;
        private final ImmutableList<? extends GuiEventListener> children;
        private boolean prevUse;
        private float currentlyUsedPos;
        private Animation currentlyUsedAnimation;
        private int overlayColor = -1879048192;
        private boolean hovered = false;
        private final boolean badSteamDeck;

        private CarouselEntry(ControllerEntity controller, int width, int height) {
            this.width = width;
            this.height = height;
            this.controller = controller;
            this.hasNickname = this.controller.genericConfig().config().nickname != null;
            this.settingsButton = Button.builder((Component)Component.translatable((String)"controlify.gui.carousel.entry.settings"), btn -> ControllerCarouselScreen.this.minecraft.setScreen(ControllerConfigScreenFactory.generateConfigScreen(ControllerCarouselScreen.this, controller))).width((this.getWidth() - 2) / 2 - 2).build();
            this.useControllerButton = Button.builder((Component)Component.empty(), btn -> this.onUseStopUsingButton()).width(this.settingsButton.getWidth()).build();
            this.updateUseStopUsingButton();
            this.children = ImmutableList.of((Object)this.settingsButton, (Object)this.useControllerButton);
            this.prevUse = this.isCurrentlyUsed();
            this.currentlyUsedPos = this.prevUse ? 1.0f : 0.0f;
            this.badSteamDeck = controller.info().type().isSteamDeck() && controller.getComponent(SteamDeckComponent.ID).isEmpty();
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            int n;
            this.hovered = this.isMouseOver(mouseX, mouseY);
            graphics.enableScissor(this.x, this.y, this.x + this.width + (this.translationX > 0.0f ? 1 : 0), this.y + this.height + (this.translationY > 0.0f ? 1 : 0));
            graphics.pose().pushPose();
            graphics.pose().translate(this.translationX, this.translationY, 0.0f);
            graphics.renderOutline(this.x, this.y, this.width, this.height, 0x5AFFFFFF);
            this.useControllerButton.render(graphics, mouseX, mouseY, delta);
            this.settingsButton.render(graphics, mouseX, mouseY, delta);
            Font font = ControllerCarouselScreen.this.font;
            String string = this.controller.name();
            int n2 = this.x + this.width / 2;
            Objects.requireNonNull(ControllerCarouselScreen.this.font);
            if (this.hasNickname) {
                Objects.requireNonNull(ControllerCarouselScreen.this.font);
                n = 9 + 1;
            } else {
                n = 0;
            }
            graphics.drawCenteredString(font, string, n2, this.y + this.height - 26 - 9 - n, 0xFFFFFF);
            if (this.hasNickname) {
                GenericControllerConfig config = this.controller.genericConfig().config();
                String nickname = config.nickname;
                config.nickname = null;
                Font font2 = ControllerCarouselScreen.this.font;
                String string2 = this.controller.name();
                int n3 = this.x + this.width / 2;
                Objects.requireNonNull(ControllerCarouselScreen.this.font);
                graphics.drawCenteredString(font2, string2, n3, this.y + this.height - 26 - 9, 0xAAAAAA);
                config.nickname = nickname;
            }
            MutableComponent currentlyInUseText = Component.translatable((String)"controlify.gui.carousel.entry.in_use").withStyle(ChatFormatting.GREEN);
            graphics.pose().pushPose();
            graphics.pose().translate((float)(17 + ControllerCarouselScreen.this.font.width((FormattedText)currentlyInUseText)) * (this.currentlyUsedPos - 1.0f), 0.0f, 0.0f);
            if (this.currentlyUsedPos > 0.0f) {
                ClientUtils.drawSprite(graphics, CHECKMARK, this.x + 4, this.y + 4, 9, 8);
                graphics.drawString(ControllerCarouselScreen.this.font, (Component)currentlyInUseText, this.x + 17, this.y + 4, -1);
            }
            if (this.badSteamDeck) {
                ClientUtils.drawSprite(graphics, DANGER, this.x + 4, this.y + 4 + 10, 9, 8);
                graphics.drawString(ControllerCarouselScreen.this.font, (Component)Component.translatable((String)"controlify.steam_deck_no_driver"), this.x + 17, this.y + 4 + 10, -1);
            }
            graphics.pose().popPose();
            int iconWidth = this.width - 6;
            Objects.requireNonNull(ControllerCarouselScreen.this.font);
            Objects.requireNonNull(ControllerCarouselScreen.this.font);
            int iconHeight = this.height - 22 - 4 - 9 - 8 - (9 * (this.hasNickname ? 2 : 1) + 1) - 6;
            int iconSize = Mth.roundToward((int)Math.min(iconHeight, iconWidth), (int)2);
            graphics.pose().pushPose();
            PoseStack poseStack = graphics.pose();
            float f = (float)this.x + (float)this.width / 2.0f - (float)iconSize / 2.0f;
            Objects.requireNonNull(ControllerCarouselScreen.this.font);
            poseStack.translate(f, (float)(this.y + 9 + 12) + (float)iconHeight / 2.0f - (float)iconSize / 2.0f, 0.0f);
            graphics.pose().scale((float)iconSize / 64.0f, (float)iconSize / 64.0f, 1.0f);
            ClientUtils.drawSprite(graphics, this.controller.info().type().getIconSprite(), 0, 0, 64, 64);
            graphics.pose().popPose();
            graphics.pose().translate(0.0f, 0.0f, 1.0f);
            graphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, this.overlayColor);
            graphics.pose().popPose();
            graphics.disableScissor();
            if (this.prevUse != this.isCurrentlyUsed()) {
                if (this.currentlyUsedAnimation != null) {
                    this.currentlyUsedAnimation.skipToEnd();
                }
                this.currentlyUsedAnimation = Animation.of(20).easing(EasingFunction.EASE_OUT_QUINT).consumerF(t -> {
                    this.currentlyUsedPos = t.floatValue();
                }, this.currentlyUsedPos, this.isCurrentlyUsed() ? 1.0 : 0.0).play();
            }
            this.prevUse = this.isCurrentlyUsed();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            int index;
            if (this.isMouseOver(mouseX, mouseY) && (index = ControllerCarouselScreen.this.carouselEntries.indexOf((Object)this)) != ControllerCarouselScreen.this.carouselIndex) {
                if (ControllerCarouselScreen.this.carouselAnimation == null || ControllerCarouselScreen.this.carouselAnimation.isDone()) {
                    ControllerCarouselScreen.this.focusOnEntry(index);
                }
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        private void onUseStopUsingButton() {
            if (!this.isCurrentlyUsed()) {
                Controlify.instance().setCurrentController(this.controller, true);
            } else {
                Controlify.instance().setCurrentController(null, true);
                Controlify.instance().config().setCurrentControllerUid(null);
            }
            this.updateUseStopUsingButton();
        }

        private void updateUseStopUsingButton() {
            this.useControllerButton.setMessage((Component)Component.translatable((String)(this.isCurrentlyUsed() ? "controlify.gui.carousel.entry.stop_using" : "controlify.gui.carousel.entry.use")));
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        }

        public void setFocused(boolean focused) {
            super.setFocused(focused);
            if (focused) {
                ControllerCarouselScreen.this.focusOnEntry(ControllerCarouselScreen.this.carouselEntries.indexOf((Object)this));
            }
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public void setX(float x) {
            this.x = (int)x;
            this.settingsButton.setX((int)x + 2);
            this.useControllerButton.setX(this.settingsButton.getX() + this.settingsButton.getWidth() + 2);
            this.translationX = x - (float)((int)x);
        }

        public void setY(float y) {
            this.y = (int)y;
            this.useControllerButton.setY((int)y + this.getHeight() - 20 - 2);
            this.settingsButton.setY(this.useControllerButton.getY());
            this.translationY = y - (float)((int)y);
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent event) {
            if (ControllerCarouselScreen.this.carouselAnimation != null && !ControllerCarouselScreen.this.carouselAnimation.isDone()) {
                return null;
            }
            return super.nextFocusPath(event);
        }

        public ScreenRectangle getRectangle() {
            return new ScreenRectangle(this.x, this.y, this.width, this.height);
        }

        public boolean isCurrentlyUsed() {
            return Controlify.instance().getCurrentController().orElse(null) == this.controller;
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return this.isFocused() ? NarratableEntry.NarrationPriority.FOCUSED : (this.hovered ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE);
        }

        public void updateNarration(NarrationElementOutput builder) {
            builder.add(NarratedElementType.TITLE, this.controller.name());
            builder.add(NarratedElementType.USAGE, (Component)Component.literal((String)"Left arrow to go to previous controller, right arrow to go to next controller."));
        }
    }
}

