/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.gui.screen.DontInteruptScreen;
import dev.isxander.controlify.utils.ClientUtils;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class DownloadingSDLScreen
extends Screen
implements DontInteruptScreen {
    private final Screen screenOnFinish;
    private final Path nativePath;
    private long receivedBytes;
    private long totalBytes;
    private final DecimalFormat format = new DecimalFormat("0.00 MB");

    public DownloadingSDLScreen(Screen screenOnFinish, long totalBytes, Path nativePath) {
        super((Component)Component.translatable((String)"controlify.downloading_sdl.title"));
        this.screenOnFinish = screenOnFinish;
        this.nativePath = nativePath;
        this.totalBytes = totalBytes;
    }

    protected void init() {
        MutableComponent filePathText = Component.literal((String)this.nativePath.getFileName().toString()).withStyle(ChatFormatting.BLUE);
        int n = this.width / 2 - this.font.width((FormattedText)filePathText) / 2;
        int n2 = this.font.width((FormattedText)filePathText);
        Objects.requireNonNull(this.font);
        this.addRenderableWidget((GuiEventListener)new PlainTextButton(n, 112, n2, 9, (Component)filePathText, btn -> Util.getPlatform().openFile(this.nativePath.toFile()), this.font));
        int paragraphWidth = this.width - 20;
        this.addRenderableWidget((GuiEventListener)new MultiLineTextWidget(this.width / 2 - paragraphWidth / 2, 139, (Component)Component.translatable((String)"controlify.downloading_sdl.info"), this.font).setMaxWidth(paragraphWidth).setCentered(true));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.width / 2.0f - (float)this.font.width((FormattedText)this.getTitle()) / 2.0f * 2.5f, 30.0f, 0.0f);
        graphics.pose().scale(2.5f, 2.5f, 1.0f);
        graphics.drawString(this.font, this.getTitle(), 0, 0, -1);
        graphics.pose().popPose();
        graphics.pose().pushPose();
        graphics.pose().scale(2.0f, 2.0f, 1.0f);
        ClientUtils.drawBar(graphics, this.width / 2 / 2, 46, (float)this.receivedBytes / (float)this.totalBytes);
        graphics.pose().popPose();
        String totalString = this.format.format((float)this.totalBytes / 1024.0f / 1024.0f);
        graphics.drawString(this.font, totalString, (int)((float)this.width / 2.0f + 182.0f - (float)this.font.width(totalString)), 104, 0xAAAAAA);
        String receivedString = this.format.format((float)this.receivedBytes / 1024.0f / 1024.0f);
        graphics.drawString(this.font, receivedString, (int)((float)this.width / 2.0f - 182.0f), 104, 0xAAAAAA);
    }

    public void updateDownloadProgress(long receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    public void finishDownload() {
        this.minecraft.setScreen(this.screenOnFinish);
    }

    public void failDownload(Throwable th) {
        this.finishDownload();
    }

    public void increaseTotal(long increment) {
        this.totalBytes += increment;
    }
}

