/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.gui.screen.RadialMenuScreen;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.DebugOverlayHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.inventory.Hotbar;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;

public final class RadialItems {
    public static final RadialMenuScreen.RadialItem EMPTY_ACTION = new RadialItemRecord((Component)Component.empty(), RadialIcon.EMPTY, () -> false, RadialIcons.EMPTY);

    public static RadialMenuScreen.RadialItem[] createBindings(ControllerEntity controller) {
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[8];
        for (int i = 0; i < 8; ++i) {
            ResourceLocation bindingId = ((InputComponent.Config)controller.input().orElseThrow().confObj()).radialActions[i];
            items[i] = RadialItems.getItemForBinding(bindingId, controller);
        }
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createGameModes() {
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[]{new GameModeItem(GameType.CREATIVE), new GameModeItem(GameType.SURVIVAL), new GameModeItem(GameType.ADVENTURE), new GameModeItem(GameType.SPECTATOR)};
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createHotbarSave() {
        Minecraft mc = Minecraft.getInstance();
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[9];
        for (int i = 0; i < 9; ++i) {
            int j = i;
            items[i] = new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.hotbar", (Object[])new Object[]{Component.literal((String)Integer.toString(j + 1))}), RadialItems.getIconForHotbar(i, true), () -> {
                CreativeModeInventoryScreen.handleHotbarLoadOrSave((Minecraft)mc, (int)j, (boolean)false, (boolean)true);
                return true;
            }, CUtil.rl("hotbar_save/" + j));
        }
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createHotbarLoad() {
        Minecraft mc = Minecraft.getInstance();
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[9];
        for (int i = 0; i < items.length; ++i) {
            int j = i;
            items[i] = new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.hotbar", (Object[])new Object[]{Component.literal((String)Integer.toString(j + 1))}), RadialItems.getIconForHotbar(i, true), () -> {
                CreativeModeInventoryScreen.handleHotbarLoadOrSave((Minecraft)mc, (int)j, (boolean)true, (boolean)false);
                return true;
            }, CUtil.rl("hotbar_load/" + j));
        }
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createHotbarItemSelect() {
        Minecraft mc = Minecraft.getInstance();
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[9];
        for (int i = 0; i < items.length; ++i) {
            int j = i;
            items[i] = new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.hotbar", (Object[])new Object[]{Component.literal((String)Integer.toString(j + 1))}), (graphics, x, y, tickDelta) -> graphics.renderItem(mc.player.getInventory().getItem(j), x, y), () -> {
                mc.player.getInventory().selected = j;
                return true;
            }, CUtil.rl("hotbar_item_select/" + j));
        }
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createDebug() {
        RadialMenuScreen.RadialItem[] radialItemArray;
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[]{new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.debug.reload_chunks"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.COMPASS)), () -> {
            DebugOverlayHelper.reloadChunks();
            return true;
        }, CUtil.rl("debug/reload_chunks")), new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.debug.chunk_borders"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.FILLED_MAP)), () -> {
            DebugOverlayHelper.toggleChunkBorders();
            return true;
        }, CUtil.rl("debug/chunk_borders")), new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.debug.advanced_tooltips"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.WRITABLE_BOOK)), () -> {
            DebugOverlayHelper.toggleAdvancedTooltips();
            return true;
        }, CUtil.rl("debug/advanced_tooltips")), new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.debug.entity_hitboxes"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.ZOMBIE_HEAD)), () -> {
            DebugOverlayHelper.toggleEntityHitboxes();
            return true;
        }, CUtil.rl("debug/entity_hitboxes")), new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.debug.reload_packs"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.PINK_DYE)), () -> {
            DebugOverlayHelper.reloadResourcePacks();
            return true;
        }, CUtil.rl("debug/reload_packs")), new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.debug.clear_chat"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.FLINT_AND_STEEL)), () -> {
            DebugOverlayHelper.clearChat();
            return true;
        }, CUtil.rl("debug/clear_chat")), new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.debug.profile"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.STRUCTURE_BLOCK)), () -> {
            DebugOverlayHelper.startStopProfiling();
            return true;
        }, CUtil.rl("debug/profile"))};
        boolean overlayEnabled = DebugOverlayHelper.isOverlayEnabled();
        if (!overlayEnabled) {
            RadialMenuScreen.RadialItem[] radialItemArray2 = new RadialMenuScreen.RadialItem[4];
            radialItemArray2[0] = new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.debug.overlay"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.DEBUG_STICK)), () -> {
                DebugOverlayHelper.toggleOverlay();
                return true;
            }, CUtil.rl("debug/overlay"));
            radialItemArray2[1] = new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.debug.overlay_fps"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.CLOCK)), () -> {
                DebugOverlayHelper.toggleFpsOverlay();
                return true;
            }, CUtil.rl("debug/fps"));
            radialItemArray2[2] = new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.debug.overlay_net"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.SCULK_SENSOR)), () -> {
                DebugOverlayHelper.toggleNetworkOverlay();
                return true;
            }, CUtil.rl("debug/fps"));
            radialItemArray = radialItemArray2;
            radialItemArray2[3] = new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.debug.overlay_prof"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.TARGET)), () -> {
                DebugOverlayHelper.toggleProfilerOverlay();
                return true;
            }, CUtil.rl("debug/fps"));
        } else {
            RadialMenuScreen.RadialItem[] radialItemArray3 = new RadialMenuScreen.RadialItem[1];
            radialItemArray = radialItemArray3;
            radialItemArray3[0] = new RadialItemRecord((Component)Component.translatable((String)"controlify.radial.debug.hide_overlay"), RadialIcons.getIcons().get(RadialIcons.getEffect((Holder<MobEffect>)MobEffects.INVISIBILITY)), () -> {
                DebugOverlayHelper.toggleOverlay();
                return true;
            }, CUtil.rl("debug/reload_chunks"));
        }
        RadialMenuScreen.RadialItem[] overlayItems = radialItemArray;
        RadialMenuScreen.RadialItem[] allItems = new RadialMenuScreen.RadialItem[items.length + overlayItems.length];
        System.arraycopy(overlayItems, 0, allItems, 0, overlayItems.length);
        System.arraycopy(items, 0, allItems, overlayItems.length, items.length);
        return allItems;
    }

    private static RadialIcon getIconForHotbar(int hotbarIndex, boolean showNumbers) {
        Minecraft mc = Minecraft.getInstance();
        Hotbar hotbar = mc.getHotbarManager().get(hotbarIndex);
        List hotbarItems = hotbar.load((HolderLookup.Provider)mc.player.registryAccess());
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = (ItemStack)hotbarItems.get(i);
            if (stack.is(Items.AIR)) continue;
            return (graphics, x, y, tickDelta) -> {
                graphics.renderItem(stack, x, y);
                if (showNumbers) {
                    graphics.pose().pushPose();
                    graphics.pose().translate(0.0f, 0.0f, 1000.0f);
                    graphics.drawString(mc.font, Integer.toString(hotbarIndex + 1), x, y, -1);
                    graphics.pose().popPose();
                }
            };
        }
        return (graphics, x, y, tickDelta) -> {
            if (showNumbers) {
                graphics.drawString(mc.font, Integer.toString(hotbarIndex + 1), x, y, -1);
            }
        };
    }

    private static RadialMenuScreen.RadialItem getItemForBinding(ResourceLocation id, ControllerEntity controller) {
        InputBinding binding = controller.input().orElseThrow().getBinding(id);
        if (binding == null || binding.radialIcon().isEmpty()) {
            CUtil.LOGGER.warn("Binding {} does not exist or is not a radial candidate", binding);
            return EMPTY_ACTION;
        }
        RadialIcon icon = RadialIcons.getIcons().get(binding.radialIcon().get());
        return new RadialItemRecord(binding.name(), icon, () -> {
            binding.fakePress();
            return true;
        }, id);
    }

    private static class GameModeItem
    implements RadialMenuScreen.RadialItem {
        private final GameType gameType;
        private final Component name;
        private final RadialIcon icon;
        private final String command;

        public GameModeItem(GameType gameType) {
            this.gameType = gameType;
            this.name = gameType.getShortDisplayName();
            ResourceLocation iconId = switch (gameType) {
                default -> throw new MatchException(null, null);
                case GameType.CREATIVE -> RadialIcons.getItem(Items.GRASS_BLOCK);
                case GameType.SURVIVAL -> RadialIcons.getItem(Items.IRON_SWORD);
                case GameType.ADVENTURE -> RadialIcons.getItem(Items.MAP);
                case GameType.SPECTATOR -> RadialIcons.getItem(Items.ENDER_EYE);
            };
            this.icon = RadialIcons.getIcons().get(iconId);
            this.command = switch (gameType) {
                default -> throw new MatchException(null, null);
                case GameType.CREATIVE -> "gamemode creative";
                case GameType.SURVIVAL -> "gamemode survival";
                case GameType.ADVENTURE -> "gamemode adventure";
                case GameType.SPECTATOR -> "gamemode spectator";
            };
        }

        @Override
        public Component name() {
            return this.name;
        }

        @Override
        public RadialIcon icon() {
            return this.icon;
        }

        @Override
        public boolean playAction() {
            Minecraft client = Minecraft.getInstance();
            if (client.gameMode != null && client.player != null && client.player.hasPermissions(2) && client.gameMode.getPlayerMode() != this.gameType) {
                client.player.connection.sendUnsignedCommand(this.command);
                return true;
            }
            return false;
        }
    }

    private record RadialItemRecord(Component name, RadialIcon icon, Supplier<Boolean> action, ResourceLocation id) implements RadialMenuScreen.RadialItem
    {
        @Override
        public boolean playAction() {
            return this.action.get();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RadialItemRecord) {
                RadialItemRecord record = (RadialItemRecord)obj;
                return this.id.equals((Object)record.id);
            }
            return false;
        }
    }

    public static class BindingEditMode
    implements RadialMenuScreen.EditMode {
        private final ControllerEntity controller;

        public BindingEditMode(ControllerEntity controller) {
            this.controller = controller;
        }

        @Override
        public void setRadialItem(int index, RadialMenuScreen.RadialItem item) {
            ((InputComponent.Config)this.controller.input().orElseThrow().confObj()).radialActions[index] = ((RadialItemRecord)item).id();
        }

        @Override
        public List<RadialMenuScreen.RadialItem> getEditCandidates() {
            ArrayList<RadialMenuScreen.RadialItem> items = new ArrayList<RadialMenuScreen.RadialItem>();
            this.controller.input().orElseThrow().getAllBindings().forEach(binding -> binding.radialIcon().ifPresent(icon -> items.add(new RadialItemRecord(binding.name(), RadialIcons.getIcons().get(icon), () -> false, binding.id()))));
            return items;
        }
    }
}

