/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.guide.screen;

import com.google.common.collect.ImmutableList;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TabNavigationBar.class})
public class TabNavigationBarMixin {
    @Shadow
    @Final
    private ImmutableList<TabButton> tabButtons;

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void renderControllerButtonOverlay(GuiGraphics graphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (Controlify.instance().currentInputMode().isController()) {
            Controlify.instance().getCurrentController().ifPresent(c -> {
                if (c.genericConfig().config().showScreenGuides) {
                    this.renderControllerButtonOverlay(graphics, (ControllerEntity)c);
                }
            });
        }
    }

    @Unique
    private void renderControllerButtonOverlay(GuiGraphics graphics, ControllerEntity controller) {
        if (this.tabButtons.size() <= 1) {
            return;
        }
        TabButton firstTab = (TabButton)this.tabButtons.get(0);
        TabButton lastTab = (TabButton)this.tabButtons.get(this.tabButtons.size() - 1);
        Font font = Minecraft.getInstance().font;
        Component prevTabText = ControlifyBindings.GUI_PREV_TAB.on(controller).inputIcon();
        int prevTabTextWidth = font.width((FormattedText)prevTabText);
        int n = firstTab.getX() - 2 - prevTabTextWidth;
        int n2 = firstTab.getY() / 2;
        Objects.requireNonNull(font);
        graphics.drawString(font, prevTabText, n, n2 + 9 / 2, 0xFFFFFF);
        Component nextTabText = ControlifyBindings.GUI_NEXT_TAB.on(controller).inputIcon();
        int n3 = lastTab.getX() + lastTab.getWidth() + 2;
        int n4 = lastTab.getY() / 2;
        Objects.requireNonNull(font);
        graphics.drawString(font, nextTabText, n3, n4 + 9 / 2, 0xFFFFFF);
    }
}

