/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.rumble.explosion;

import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.rumble.BasicRumbleEffect;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import dev.isxander.controlify.utils.Easings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public class ClientPacketListenerMixin {
    @Inject(method={"handleExplosion"}, at={@At(value="RETURN")})
    private void onClientExplosion(ClientboundExplodePacket packet, CallbackInfo ci) {
        float initialMagnitude = this.calculateMagnitude(packet);
        ControlifyApi.get().getCurrentController().flatMap(ControllerEntity::rumble).ifPresent(rumble -> rumble.rumbleManager().play(RumbleSource.WORLD, BasicRumbleEffect.join(BasicRumbleEffect.constant(initialMagnitude, initialMagnitude, 4), BasicRumbleEffect.byTime(t -> {
            float magnitude = this.calculateMagnitude(packet);
            return new RumbleState(0.0f, magnitude - t.floatValue() * magnitude);
        }, 20))));
    }

    private float calculateMagnitude(ClientboundExplodePacket packet) {
        double x = packet.getX();
        double y = packet.getY();
        double z = packet.getZ();
        float power = packet.getPower();
        float distanceSqr = Math.max((float)Minecraft.getInstance().player.distanceToSqr(x, y, z) - power * power, 0.0f);
        float maxDistanceSqr = 4096.0f;
        return 1.0f - (float)Easings.easeOutQuad(distanceSqr / maxDistanceSqr);
    }
}

