/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.rumble.fishing;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.rumble.ContinuousRumbleEffect;
import dev.isxander.controlify.rumble.RumbleSource;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FishingHook;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FishingHook.class})
public class FishingHookMixin {
    @Shadow
    private boolean biting;
    @Unique
    private boolean isLocalPlayerHook;
    @Unique
    private ContinuousRumbleEffect bitingRumble;

    @ModifyExpressionValue(method={"onSyncedDataUpdated"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/syncher/SynchedEntityData;get(Lnet/minecraft/network/syncher/EntityDataAccessor;)Ljava/lang/Object;", ordinal=1)})
    private Object onBitingStateUpdated(Object bitingObj) {
        boolean biting = (Boolean)bitingObj;
        if (this.isLocalPlayerHook) {
            if (biting && !this.biting) {
                ControlifyApi.get().getCurrentController().flatMap(ControllerEntity::rumble).ifPresent(controller -> {
                    this.bitingRumble = ContinuousRumbleEffect.builder().constant(0.0f, 0.05f).build();
                    controller.rumbleManager().play(RumbleSource.INTERACTION, this.bitingRumble);
                });
            } else if (!biting && this.biting) {
                this.stopBitingRumble();
            }
        }
        return biting;
    }

    @Inject(method={"onClientRemoval"}, at={@At(value="RETURN")})
    private void onClientRemoval(CallbackInfo ci) {
        this.stopBitingRumble();
    }

    @Unique
    private void stopBitingRumble() {
        if (this.bitingRumble != null) {
            this.bitingRumble.stop();
            this.bitingRumble = null;
        }
    }

    @Inject(method={"setOwner"}, at={@At(value="RETURN")})
    private void onOwnerSet(@Nullable Entity entity, CallbackInfo ci) {
        this.isLocalPlayerHook = entity instanceof LocalPlayer;
    }
}

