/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.screenkeyboard;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.controller.keyboard.NativeKeyboardComponent;
import dev.isxander.controlify.screenkeyboard.ChatKeyboardDucky;
import dev.isxander.controlify.screenkeyboard.ChatKeyboardWidget;
import dev.isxander.controlify.screenkeyboard.KeyPressConsumer;
import java.util.Optional;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatScreen.class})
public abstract class ChatScreenMixin
extends Screen
implements ChatKeyboardDucky {
    @Unique
    private ChatKeyboardWidget keyboard;
    @Unique
    private float shiftChatAmt = 0.0f;
    @Shadow
    protected EditBox input;

    @Shadow
    public abstract boolean keyPressed(int var1, int var2, int var3);

    protected ChatScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void addKeyboard(CallbackInfo ci) {
        ControlifyApi.get().getCurrentController().ifPresent(c -> {
            if (!ControlifyApi.get().currentInputMode().isController()) {
                return;
            }
            if (!c.genericConfig().config().showOnScreenKeyboard) {
                return;
            }
            Optional<NativeKeyboardComponent> nativeKeyboardOpt = c.nativeKeyboard();
            if (nativeKeyboardOpt.isPresent() && ((NativeKeyboardComponent.Config)nativeKeyboardOpt.get().confObj()).useNativeKeyboard) {
                NativeKeyboardComponent nativeKeyboard = nativeKeyboardOpt.get();
                this.shiftChatAmt = nativeKeyboard.getKeyboardHeight();
                nativeKeyboard.open();
            } else {
                this.shiftChatAmt = 0.5f;
                int keyboardHeight = (int)((float)this.height * this.shiftChatAmt);
                this.keyboard = new ChatKeyboardWidget((Screen)((ChatScreen)this), 0, this.height - keyboardHeight, this.width, keyboardHeight, KeyPressConsumer.of((keycode, scancode, modifiers) -> {
                    this.input.keyPressed(keycode, scancode, modifiers);
                    this.keyPressed(keycode, scancode, modifiers);
                }, (codePoint, modifiers) -> {
                    this.charTyped(codePoint, modifiers);
                    this.input.charTyped(codePoint, modifiers);
                }));
                this.addRenderableWidget((GuiEventListener)this.keyboard);
            }
        });
    }

    @ModifyArg(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/ChatScreen$1;<init>(Lnet/minecraft/client/gui/screens/ChatScreen;Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/network/chat/Component;)V"), index=3)
    private int modifyInputBoxY(int y) {
        return (int)((float)y - (float)this.height * this.shiftChatAmt);
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"), index=1)
    private int modifyInputBoxBackgroundY(int y) {
        return (int)((float)y - (float)this.height * this.shiftChatAmt);
    }

    @ModifyExpressionValue(method={"init"}, at={@At(value="CONSTANT", args={"intValue=10"})})
    private int modifyMaxSuggestionCount(int count) {
        return this.shiftChatAmt > 0.0f ? 8 : count;
    }

    @Override
    public float controlify$keyboardShiftAmount() {
        return this.shiftChatAmt;
    }
}

