/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.screenop.vanilla;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.screenop.compat.vanilla.AbstractContainerScreenProcessor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin
implements ScreenProcessorProvider {
    @Shadow
    @Nullable
    protected Slot hoveredSlot;
    @Unique
    protected AbstractContainerScreenProcessor<?> screenProcessor = new AbstractContainerScreenProcessor<AbstractContainerScreen>((AbstractContainerScreen)this, () -> this.hoveredSlot, this::slotClicked, this::handleControllerItemSlotActions);

    @Shadow
    protected abstract void slotClicked(Slot var1, int var2, int var3, ClickType var4);

    @Override
    public ScreenProcessor<?> screenProcessor() {
        return this.screenProcessor;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void setPrevSlotShare(GuiGraphics graphics, int mouseX, int mouseY, float delta, CallbackInfo ci, @Share(value="prevSlot") LocalRef<Slot> prevSlot) {
        prevSlot.set((Object)this.hoveredSlot);
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void triggerSlotHovered(GuiGraphics graphics, int mouseX, int mouseY, float delta, CallbackInfo ci, @Share(value="prevSlot") LocalRef<Slot> prevSlot) {
        @Nullable Slot oldSlot = (Slot)prevSlot.get();
        @Nullable Slot newSlot = this.hoveredSlot;
        if ((oldSlot != null || newSlot != null) && (oldSlot == null || newSlot != null && newSlot.index != oldSlot.index)) {
            this.screenProcessor.onHoveredSlotChanged(newSlot, oldSlot);
        }
    }

    @Unique
    protected boolean handleControllerItemSlotActions(ControllerEntity controller) {
        return false;
    }
}

