/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.screenop.vanilla;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalDoubleRef;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={MerchantScreen.class})
public class MerchantScreenMixin {
    @Shadow
    int scrollOff;
    @Unique
    private double accumulatedScroll = 0.0;

    @ModifyExpressionValue(method={"mouseScrolled"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/MerchantScreen;canScroll(I)Z")})
    private boolean accumulateScrolling(boolean canScroll, @Local(ordinal=3, argsOnly=true) LocalDoubleRef scrollYRef) {
        if (canScroll) {
            double scrollY = scrollYRef.get();
            if ((int)scrollY == 0 && scrollY != 0.0) {
                if (Math.signum(this.accumulatedScroll) != Math.signum(scrollY)) {
                    this.accumulatedScroll = 0.0;
                }
                this.accumulatedScroll += scrollY;
            }
            scrollYRef.set(this.accumulatedScroll);
        }
        return canScroll;
    }

    @ModifyExpressionValue(method={"mouseScrolled"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(III)I")})
    private int resetAccumulatedScroll(int original, @Local(ordinal=3, argsOnly=true) double scrollY) {
        int relativeScroll = (int)((double)this.scrollOff - scrollY);
        this.accumulatedScroll -= (double)relativeScroll;
        return original;
    }
}

