/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.virtualmouse.snapping;

import dev.isxander.controlify.api.vmousesnapping.ISnapBehaviour;
import dev.isxander.controlify.api.vmousesnapping.SnapPoint;
import dev.isxander.controlify.mixins.feature.virtualmouse.snapping.AbstractContainerScreenMixin;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.world.inventory.LoomMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LoomScreen.class})
public abstract class LoomMixin
extends AbstractContainerScreenMixin<LoomMenu>
implements ISnapBehaviour {
    @Unique
    private static final int COLUMNS = 4;
    @Unique
    private static final int ROWS = 4;
    @Unique
    private static final int SLOTS = 16;
    @Unique
    private static final int BTN_SIZE = 14;
    @Shadow
    private boolean displayPatterns;
    @Shadow
    private int startRow;

    @Override
    public void controlify$collectSnapPoints(Consumer<SnapPoint> consumer) {
        super.controlify$collectSnapPoints(consumer);
        if (!this.displayPatterns) {
            return;
        }
        List patterns = ((LoomMenu)this.menu).getSelectablePatterns();
        if (patterns.isEmpty()) {
            return;
        }
        int numPatterns = patterns.size();
        int gridLeft = this.leftPos + 60;
        int gridTop = this.topPos + 14;
        int firstIndex = this.startRow * 4;
        int endPatternIndexExclusive = Math.min(numPatterns, firstIndex + 16);
        for (int patternIndex = firstIndex; patternIndex < endPatternIndexExclusive; ++patternIndex) {
            int absoluteRow = patternIndex / 4;
            int gridColumn = patternIndex % 4;
            int gridRow = absoluteRow - this.startRow;
            int buttonX = gridLeft + gridColumn * 14 + 7;
            int buttonY = gridTop + gridRow * 14 + 7;
            consumer.accept(new SnapPoint(buttonX, buttonY, 7));
        }
    }
}

