/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.rumble;

import dev.isxander.controlify.rumble.RumbleEffect;
import dev.isxander.controlify.rumble.RumbleState;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;

public class ContinuousRumbleEffect
implements RumbleEffect {
    private final Function<Integer, RumbleState> stateFunction;
    private final int priority;
    private final int timeout;
    private final int minTime;
    private int tick;
    private int age;
    private boolean stopped;
    private BooleanSupplier stopCondition;

    public ContinuousRumbleEffect(Function<Integer, RumbleState> stateFunction, int priority, int timeout, int minTime, BooleanSupplier stopCondition) {
        this.stateFunction = stateFunction;
        this.priority = priority;
        this.timeout = timeout;
        this.minTime = minTime;
        this.stopCondition = stopCondition;
    }

    @Override
    public void tick() {
        ++this.tick;
        ++this.age;
        if (this.stopCondition.getAsBoolean()) {
            this.stop();
        }
    }

    @Override
    public RumbleState currentState() {
        if (this.tick == 0) {
            throw new IllegalStateException("Effect hasn't ticked yet.");
        }
        return this.stateFunction.apply(this.tick - 1);
    }

    public void stop() {
        this.stopped = true;
    }

    public void heartbeat() {
        this.age = 0;
    }

    @Override
    public int age() {
        return this.tick;
    }

    @Override
    public boolean isFinished() {
        return (this.stopped || this.timeout > 0 && this.age >= this.timeout) && this.tick >= this.minTime;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Function<Integer, RumbleState> stateFunction;
        private int priority;
        private int timeout = -1;
        private int minTime;
        private InWorldProperties inWorldProperties;
        private BooleanSupplier stopCondition = () -> false;

        private Builder() {
        }

        public Builder byTick(Function<Integer, RumbleState> stateFunction) {
            this.stateFunction = stateFunction;
            return this;
        }

        public Builder constant(RumbleState state) {
            this.stateFunction = tick -> state;
            return this;
        }

        public Builder constant(float strong, float weak) {
            return this.constant(new RumbleState(strong, weak));
        }

        public Builder timeout(int timeoutTicks) {
            Validate.isTrue((timeoutTicks >= 0 ? 1 : 0) != 0, (String)"the timeout cannot be negative!", (Object[])new Object[0]);
            this.timeout = timeoutTicks;
            return this;
        }

        public Builder minTime(int minTimeTicks) {
            Validate.isTrue((minTimeTicks >= 0 ? 1 : 0) != 0, (String)"the minimum time cannot be negative!", (Object[])new Object[0]);
            this.minTime = minTimeTicks;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder inWorld(Supplier<Vec3> sourceLocation, float min, float max, float effectRange, Function<Float, Float> fallofFunction) {
            this.inWorldProperties = new InWorldProperties(sourceLocation, min, max, effectRange, fallofFunction);
            this.stopCondition(() -> Minecraft.getInstance().cameraEntity == null);
            return this;
        }

        public Builder stopCondition(BooleanSupplier stopCondition) {
            BooleanSupplier oldStopCondition = this.stopCondition;
            this.stopCondition = () -> stopCondition.getAsBoolean() || oldStopCondition.getAsBoolean();
            return this;
        }

        public ContinuousRumbleEffect build() {
            Validate.notNull(this.stateFunction, (String)"stateFunction cannot be null!", (Object[])new Object[0]);
            Validate.isTrue((this.minTime <= this.timeout || this.timeout == -1 ? 1 : 0) != 0, (String)"the minimum time cannot be greater than the timeout!", (Object[])new Object[0]);
            Function<Integer, RumbleState> stateFunction = this.stateFunction;
            if (this.inWorldProperties != null) {
                stateFunction = this.inWorldProperties.modify(stateFunction);
            }
            return new ContinuousRumbleEffect(stateFunction, this.priority, this.timeout, this.minTime, this.stopCondition);
        }

        private record InWorldProperties(Supplier<Vec3> sourceLocation, float minMagnitude, float maxMagnitude, float effectRange, Function<Float, Float> fallofFunction) {
            private Function<Integer, RumbleState> modify(Function<Integer, RumbleState> stateFunction) {
                return tick -> {
                    if (Minecraft.getInstance().cameraEntity == null) {
                        return RumbleState.NONE;
                    }
                    float distanceSqr = (float)Minecraft.getInstance().cameraEntity.distanceToSqr(this.sourceLocation.get());
                    float normalizedDistance = Mth.clamp((float)(distanceSqr / (this.effectRange * this.effectRange)), (float)0.0f, (float)1.0f);
                    float multiplier = Mth.lerp((float)this.fallofFunction.apply(Float.valueOf(1.0f - normalizedDistance)).floatValue(), (float)this.minMagnitude, (float)this.maxMagnitude);
                    return ((RumbleState)stateFunction.apply((Integer)tick)).mul(multiplier);
                };
            }
        }
    }
}

