/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ScreenProcessor;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.network.chat.CommonComponents;

public class JoinMultiplayerScreenProcessor
extends ScreenProcessor<JoinMultiplayerScreen> {
    private final Supplier<ServerSelectionList> listSupplier;

    public JoinMultiplayerScreenProcessor(JoinMultiplayerScreen screen, Supplier<ServerSelectionList> listSupplier) {
        super(screen);
        this.listSupplier = listSupplier;
    }

    @Override
    protected void handleButtons(ControllerEntity controller) {
        if (ControlifyBindings.GUI_BACK.on(controller).justPressed()) {
            this.getWidget(CommonComponents.GUI_BACK).ifPresent(back -> {
                if (!back.isFocused()) {
                    ServerSelectionList list = this.listSupplier.get();
                    list.setSelected(null);
                    list.setFocused(null);
                    ((JoinMultiplayerScreen)this.screen).setFocused((GuiEventListener)back);
                } else {
                    ((AbstractButton)back).onPress();
                }
            });
        }
        super.handleButtons(controller);
    }

    @Override
    public void onWidgetRebuild() {
        this.getWidget(CommonComponents.GUI_BACK).ifPresent(button -> ButtonGuideApi.addGuideToButton((AbstractButton)button, ControlifyBindings.GUI_BACK, ButtonGuidePredicate.always()));
        super.onWidgetRebuild();
    }
}

