/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils.render;

import dev.isxander.controlify.utils.render.SpriteScaling;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public record ControlifySprite(ResourceLocation atlas, SpriteScaling scaling, float u0, float u1, float v0, float v1, RenderType renderType) {
    public ControlifySprite(ResourceLocation atlas, SpriteScaling scaling, float u0, float u1, float v0, float v1) {
        this(atlas, scaling, u0, u1, v0, v1, RenderType.text((ResourceLocation)atlas));
    }

    public ControlifySprite(TextureAtlasSprite sprite, GuiSpriteScaling scaling) {
        this(sprite.atlasLocation(), ControlifySprite.fromVanillaScale(scaling), sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1());
    }

    public float getU(float delta) {
        return Mth.lerp((float)delta, (float)this.u0, (float)this.u1);
    }

    public float getV(float delta) {
        return Mth.lerp((float)delta, (float)this.v0, (float)this.v1);
    }

    public static ControlifySprite fromSpriteId(ResourceLocation spriteId) {
        GuiSpriteManager sprites = Minecraft.getInstance().getGuiSprites();
        TextureAtlasSprite sprite = sprites.getSprite(spriteId);
        GuiSpriteScaling scaling = sprites.getSpriteScaling(sprite);
        return new ControlifySprite(sprite, scaling);
    }

    private static SpriteScaling fromVanillaScale(GuiSpriteScaling scaling) {
        if (scaling instanceof GuiSpriteScaling.Stretch) {
            return new SpriteScaling.Stretch();
        }
        if (scaling instanceof GuiSpriteScaling.Tile) {
            GuiSpriteScaling.Tile tile = (GuiSpriteScaling.Tile)scaling;
            return new SpriteScaling.Tiled(tile.width(), tile.height());
        }
        if (scaling instanceof GuiSpriteScaling.NineSlice) {
            GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)scaling;
            return new SpriteScaling.NineSlice(nineSlice.width(), nineSlice.height(), new SpriteScaling.NineSlice.Border(nineSlice.border().left(), nineSlice.border().right(), nineSlice.border().top(), nineSlice.border().bottom()));
        }
        throw new IllegalArgumentException("Unknown scaling");
    }
}

