/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils.render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.isxander.controlify.utils.ColorUtils;
import org.joml.Matrix4f;

public interface ControlifyVertexConsumer {
    public ControlifyVertexConsumer vertex(float var1, float var2, float var3);

    public ControlifyVertexConsumer vertex(Matrix4f var1, float var2, float var3, float var4);

    public ControlifyVertexConsumer endVertex();

    public ControlifyVertexConsumer color(int var1, int var2, int var3, int var4);

    default public ControlifyVertexConsumer color(int color) {
        return this.color(ColorUtils.argbRed(color), ColorUtils.argbGreen(color), ColorUtils.argbBlue(color), ColorUtils.argbAlpha(color));
    }

    public ControlifyVertexConsumer uv(float var1, float var2);

    public ControlifyVertexConsumer uv2(int var1, int var2);

    public ControlifyVertexConsumer normal(float var1, float var2, float var3);

    public VertexConsumer getVanilla();

    public static ControlifyVertexConsumer of(VertexConsumer vanilla) {
        return new Post21VertexConsumer(vanilla);
    }

    public static class Post21VertexConsumer
    implements ControlifyVertexConsumer {
        private final VertexConsumer vertexConsumer;

        public Post21VertexConsumer(VertexConsumer vertexConsumer) {
            this.vertexConsumer = vertexConsumer;
        }

        @Override
        public ControlifyVertexConsumer vertex(float x, float y, float z) {
            this.vertexConsumer.addVertex(x, y, z);
            return this;
        }

        @Override
        public ControlifyVertexConsumer vertex(Matrix4f matrix, float x, float y, float z) {
            this.vertexConsumer.addVertex(matrix, x, y, z);
            return this;
        }

        @Override
        public ControlifyVertexConsumer endVertex() {
            return this;
        }

        @Override
        public ControlifyVertexConsumer color(int red, int green, int blue, int alpha) {
            this.vertexConsumer.setColor(red, green, blue, alpha);
            return this;
        }

        @Override
        public ControlifyVertexConsumer uv(float u, float v) {
            this.vertexConsumer.setUv(u, v);
            return this;
        }

        @Override
        public ControlifyVertexConsumer uv2(int u, int v) {
            this.vertexConsumer.setUv2(u, v);
            return this;
        }

        @Override
        public ControlifyVertexConsumer normal(float x, float y, float z) {
            this.vertexConsumer.setNormal(x, y, z);
            return this;
        }

        @Override
        public VertexConsumer getVanilla() {
            return this.vertexConsumer;
        }
    }
}

