/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.guide;

import dev.isxander.controlify.api.guide.InGameCtx;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.GenericControllerConfig;
import dev.isxander.controlify.gui.guide.GuideDomains;
import dev.isxander.controlify.gui.guide.GuideRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class InGameButtonGuide {
    private final ControllerEntity controller;
    private final Minecraft minecraft;

    public InGameButtonGuide(ControllerEntity controller, Minecraft minecraft) {
        this.controller = controller;
        this.minecraft = minecraft;
    }

    public void renderHud(GuiGraphics graphics, float tickDelta) {
        boolean debugOpen = this.minecraft.getDebugOverlay().showDebugScreen();
        boolean hideGui = this.minecraft.options.hideGui;
        boolean screenOpen = this.minecraft.screen != null;
        GenericControllerConfig config = this.controller.genericConfig().config();
        if (!debugOpen && !hideGui && !screenOpen && config.showIngameGuide) {
            GuideRenderer.render(graphics, GuideDomains.IN_GAME, this.minecraft, config.ingameGuideBottom, true);
        }
    }

    public void tick() {
        GenericControllerConfig config = this.controller.genericConfig().config();
        if (config.showIngameGuide) {
            if (this.minecraft.hitResult == null) {
                this.minecraft.gameRenderer.pick(1.0f);
            }
            GuideDomains.IN_GAME.updateGuides(new InGameCtx(this.minecraft, this.minecraft.player, this.minecraft.level, this.minecraft.hitResult, this.controller, config.guideVerbosity), this.minecraft.font);
        }
    }
}

