/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.gui.controllers.BindController;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.utils.render.CGuiPose;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class BindConsumerScreen
extends Screen
implements ScreenProcessorProvider {
    private final BindConsumer bindConsumer;
    private final Option<Input> option;
    private final Screen backgroundScreen;
    private final BindController.BindControllerElement widgetToFocus;
    private final ScreenProcessorImpl screenProcessor = new ScreenProcessorImpl(this);
    private int ticksTillClose;
    private int ticksTillInput;

    public BindConsumerScreen(BindConsumer bindConsumer, Option<Input> option, BindController.BindControllerElement widgetToFocus, Screen backgroundScreen) {
        super((Component)Component.empty());
        this.bindConsumer = bindConsumer;
        this.option = option;
        this.widgetToFocus = widgetToFocus;
        this.backgroundScreen = backgroundScreen;
        this.ticksTillInput = 5;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float tickDelta) {
        Dimension dim = this.widgetToFocus.getDimension();
        CGuiPose pose = CGuiPose.ofPush(guiGraphics);
        this.backgroundScreen.render(guiGraphics, ((Integer)dim.centerX()).intValue(), ((Integer)dim.centerY()).intValue(), tickDelta);
        pose.pop();
        pose.push();
        pose.nextLayer(1000.0f);
        guiGraphics.fill(0, 0, this.width, (Integer)dim.y() - 1, Integer.MIN_VALUE);
        guiGraphics.fill(0, ((Integer)dim.y()).intValue(), (Integer)dim.x() - 1, this.height, Integer.MIN_VALUE);
        guiGraphics.fill((Integer)dim.xLimit() + 1, (Integer)dim.y() - 1, this.width, this.height, Integer.MIN_VALUE);
        guiGraphics.fill(((Integer)dim.x()).intValue(), (Integer)dim.yLimit() + 1, ((Integer)dim.xLimit()).intValue(), this.height, Integer.MIN_VALUE);
        pose.pop();
        super.render(guiGraphics, mouseX, mouseY, tickDelta);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    public void tick() {
        Optional<Input> pressedBind;
        if (this.ticksTillClose > 0) {
            --this.ticksTillClose;
            if (this.ticksTillClose == 0) {
                this.widgetToFocus.awaitingControllerInput = false;
                this.minecraft.screen = this.backgroundScreen;
            }
        }
        if (this.ticksTillInput > 0) {
            --this.ticksTillInput;
            if (this.ticksTillInput > 0) {
                return;
            }
        }
        if ((pressedBind = this.bindConsumer.getPressedBind()).isPresent()) {
            this.option.requestSet((Object)pressedBind.get());
            this.returnToBackground();
        }
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        boolean consumed = super.keyPressed(keyEvent);
        if (consumed) {
            return true;
        }
        if (this.ticksTillInput > 0) {
            return false;
        }
        this.returnToBackground();
        return true;
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
        boolean consumed = super.mouseClicked(mouseButtonEvent, doubleClick);
        if (consumed) {
            return true;
        }
        if (this.ticksTillInput > 0) {
            return false;
        }
        this.returnToBackground();
        return true;
    }

    public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double dx, double dy) {
        boolean consumed = super.mouseDragged(mouseButtonEvent, dx, dy);
        if (consumed) {
            return true;
        }
        if (this.ticksTillInput > 0) {
            return false;
        }
        this.returnToBackground();
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount, double d) {
        boolean consumed = super.mouseScrolled(mouseX, mouseY, amount, d);
        if (consumed) {
            return true;
        }
        if (this.ticksTillInput > 0) {
            return false;
        }
        this.returnToBackground();
        return true;
    }

    private void returnToBackground() {
        this.ticksTillClose = 5;
    }

    @Override
    public ScreenProcessor<?> screenProcessor() {
        return this.screenProcessor;
    }

    private static class ScreenProcessorImpl
    extends ScreenProcessor<BindConsumerScreen> {
        public ScreenProcessorImpl(BindConsumerScreen screen) {
            super(screen);
        }

        @Override
        public void onControllerUpdate(ControllerEntity controller) {
        }
    }

    public static interface BindConsumer {
        public Optional<Input> getPressedBind();
    }
}

