/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.rumble;

import dev.isxander.controlify.rumble.RumbleEffect;
import dev.isxander.controlify.rumble.RumbleState;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.apache.commons.lang3.Validate;

public final class BasicRumbleEffect
implements RumbleEffect {
    private final RumbleState[] keyframes;
    private int tick = 0;
    private boolean finished;
    private int priority = 0;
    private BooleanSupplier earlyFinishCondition = () -> false;

    public BasicRumbleEffect(RumbleState[] keyframes) {
        this.keyframes = keyframes;
    }

    @Override
    public void tick() {
        ++this.tick;
        if (this.tick >= this.keyframes.length || this.earlyFinishCondition.getAsBoolean()) {
            this.finished = true;
        }
    }

    @Override
    public RumbleState currentState() {
        if (this.tick == 0) {
            throw new IllegalStateException("Effect hasn't ticked yet.");
        }
        return this.keyframes[this.tick - 1];
    }

    @Override
    public int age() {
        return this.tick;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    public BasicRumbleEffect prioritised(int priority) {
        this.priority = priority;
        return this;
    }

    public RumbleState[] states() {
        return this.keyframes;
    }

    public BasicRumbleEffect earlyFinish(BooleanSupplier condition) {
        BooleanSupplier current = this.earlyFinishCondition;
        this.earlyFinishCondition = () -> current.getAsBoolean() || condition.getAsBoolean();
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BasicRumbleEffect that = (BasicRumbleEffect)obj;
        return Arrays.equals(this.states(), that.states()) && this.priority() == that.priority();
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.states()), this.priority());
    }

    public String toString() {
        return "RumbleEffect[states=" + Arrays.toString(this.states()) + ",priority=" + this.priority() + "]";
    }

    public BasicRumbleEffect join(BasicRumbleEffect other) {
        return BasicRumbleEffect.join(this, other);
    }

    public BasicRumbleEffect repeat(int count) {
        Validate.isTrue((count > 0 ? 1 : 0) != 0, (String)"count must be greater than 0", (Object[])new Object[0]);
        if (count == 1) {
            return this;
        }
        BasicRumbleEffect effect = this;
        for (int i = 0; i < count - 1; ++i) {
            effect = BasicRumbleEffect.join(effect, this);
        }
        return effect;
    }

    public static BasicRumbleEffect byTick(Function<Integer, RumbleState> stateFunction, int durationTicks) {
        RumbleState[] states = new RumbleState[durationTicks];
        for (int i = 0; i < durationTicks; ++i) {
            states[i] = stateFunction.apply(i);
        }
        return new BasicRumbleEffect(states);
    }

    public static BasicRumbleEffect byTime(Function<Float, RumbleState> stateFunction, int durationTicks) {
        return BasicRumbleEffect.byTick(tick -> (RumbleState)stateFunction.apply(Float.valueOf((float)tick.intValue() / (float)durationTicks)), durationTicks);
    }

    public static BasicRumbleEffect constant(float strong, float weak, int durationTicks) {
        return BasicRumbleEffect.byTick(tick -> new RumbleState(strong, weak), durationTicks);
    }

    public static BasicRumbleEffect empty(int durationTicks) {
        return BasicRumbleEffect.byTick(tick -> new RumbleState(0.0f, 0.0f), durationTicks);
    }

    public static BasicRumbleEffect join(BasicRumbleEffect ... effects) {
        RumbleState[] states = (RumbleState[])Arrays.stream(effects).flatMap(effect -> Arrays.stream(effect.states())).toArray(RumbleState[]::new);
        return new BasicRumbleEffect(states);
    }

    public static BooleanSupplier finishOnScreenChange() {
        Screen screen = Minecraft.getInstance().screen;
        return () -> screen != Minecraft.getInstance().screen;
    }
}

