/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.StateAccess;
import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.bindings.output.AnalogueOutput;
import dev.isxander.controlify.bindings.output.DigitalOutput;
import dev.isxander.controlify.bindings.output.GuiPressOutput;
import dev.isxander.controlify.bindings.output.JustPressedOutput;
import dev.isxander.controlify.bindings.output.JustReleasedOutput;
import dev.isxander.controlify.bindings.output.JustTappedOutput;
import dev.isxander.controlify.bindings.output.SimpleAnalogueOutput;
import dev.isxander.controlify.bindings.output.SimpleDigitalOutput;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.ControllerStateView;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.utils.ResizableRingBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class InputBindingImpl
implements InputBinding {
    private final ControllerEntity controller;
    private final ResourceLocation id;
    private final Component name;
    private final Component description;
    private final Component category;
    private Input boundInput;
    private final Supplier<Input> defaultBindSupplier;
    private final Set<BindContext> contexts;
    @Nullable
    private final ResourceLocation radialIcon;
    private final ResizableRingBuffer<Float> stateHistory;
    private final Set<StateAccessImpl> borrowedAccesses;
    private boolean suppressed;
    private final AnalogueOutput analogueNow;
    private final AnalogueOutput analoguePrev;
    private final DigitalOutput digitalNow;
    private final DigitalOutput digitalThen;
    private final DigitalOutput justPressed;
    private final DigitalOutput justReleased;
    private final DigitalOutput justTapped;
    private final GuiPressOutput guiPressOutput;
    private final Map<ResourceLocation, DigitalOutput> digitalOutputs;
    private final Map<ResourceLocation, AnalogueOutput> analogueOutputs;
    private int fakePressState = -1;

    public InputBindingImpl(ControllerEntity controller, ResourceLocation id, Component name, Component description, Component category, Supplier<Input> defaultBindSupplier, Set<BindContext> contexts, @Nullable ResourceLocation radialIcon) {
        this.controller = controller;
        this.id = id;
        this.name = name;
        this.description = description;
        this.category = category;
        this.stateHistory = new ResizableRingBuffer<Float>(2, () -> Float.valueOf(0.0f));
        this.boundInput = defaultBindSupplier.get();
        this.defaultBindSupplier = defaultBindSupplier;
        this.contexts = contexts;
        this.radialIcon = radialIcon;
        this.borrowedAccesses = new HashSet<StateAccessImpl>();
        this.digitalOutputs = new HashMap<ResourceLocation, DigitalOutput>();
        this.analogueOutputs = new HashMap<ResourceLocation, AnalogueOutput>();
        this.analogueNow = this.addAnalogueOutput(ANALOGUE_NOW, new SimpleAnalogueOutput(this, 0));
        this.analoguePrev = this.addAnalogueOutput(ANALOGUE_PREV, new SimpleAnalogueOutput(this, 1));
        this.digitalNow = this.addDigitalOutput(DIGITAL_NOW, new SimpleDigitalOutput(this, 0));
        this.digitalThen = this.addDigitalOutput(DIGITAL_PREV, new SimpleDigitalOutput(this, 1));
        this.justPressed = this.addDigitalOutput(JUST_PRESSED, new JustPressedOutput(this));
        this.justReleased = this.addDigitalOutput(JUST_RELEASED, new JustReleasedOutput(this));
        this.justTapped = this.addDigitalOutput(JUST_TAPPED, new JustTappedOutput(this));
        this.guiPressOutput = this.addDigitalOutput(GUI_PRESSED, new GuiPressOutput(this));
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    @Override
    public Component name() {
        return this.name;
    }

    @Override
    public Component description() {
        return this.description;
    }

    @Override
    public Component category() {
        return this.category;
    }

    @Override
    public Component inputGlyph() {
        return Controlify.instance().inputFontMapper().getComponentFromInputs(this.controller.info().type().namespace(), this.boundInput.getRelevantInputs());
    }

    @Override
    public StateAccess createStateAccess(int historyRequired) {
        return this.createStateAccess(historyRequired, null);
    }

    @Override
    public StateAccess createStateAccess(int historyRequired, Consumer<StateAccess> pushEvent) {
        if (historyRequired > this.stateHistory.size()) {
            this.stateHistory.setSize(historyRequired);
        }
        StateAccessImpl access = new StateAccessImpl(historyRequired, pushEvent);
        this.borrowedAccesses.add(access);
        return access;
    }

    @Override
    public void returnStateAccess(StateAccess stateAccess) {
        if (stateAccess instanceof StateAccessImpl) {
            StateAccessImpl accessImpl = (StateAccessImpl)stateAccess;
            boolean removed = this.borrowedAccesses.remove(accessImpl);
            accessImpl.retire();
            if (removed) {
                OptionalInt newMaxSize = this.borrowedAccesses.stream().mapToInt(StateAccessImpl::maxHistory).max();
                newMaxSize.ifPresent(this.stateHistory::setSize);
            }
        } else {
            throw new IllegalStateException("Unknown implementation of state access");
        }
    }

    @Override
    public void pushState(ControllerStateView state) {
        if (!this.contexts.isEmpty()) {
            Set<BindContext> thisTickContexts = Controlify.instance().thisTickBindContexts();
            this.suppressed = this.contexts.stream().noneMatch(thisTickContexts::contains);
        } else {
            this.suppressed = false;
        }
        float analogue = this.boundInput.state(state);
        switch (this.fakePressState) {
            case 0: {
                analogue = 0.0f;
                break;
            }
            case 1: 
            case 2: {
                analogue = 1.0f;
                break;
            }
            case 3: {
                analogue = 0.0f;
            }
        }
        if (this.fakePressState >= 0) {
            this.fakePressState = this.fakePressState == 3 ? -1 : ++this.fakePressState;
        }
        this.stateHistory.push(Float.valueOf(analogue));
        this.borrowedAccesses.forEach(StateAccessImpl::onPush);
    }

    @Override
    public void fakePress() {
        this.fakePressState = 0;
    }

    @Override
    public void setBoundInput(Input input) {
        this.boundInput = input;
        Controlify.instance().config().setDirty();
    }

    @Override
    public Input boundInput() {
        return this.boundInput;
    }

    @Override
    public Input defaultInput() {
        return this.defaultBindSupplier.get();
    }

    @Override
    public Set<BindContext> contexts() {
        return this.contexts;
    }

    @Override
    public Optional<ResourceLocation> radialIcon() {
        return Optional.ofNullable(this.radialIcon);
    }

    @Override
    public float analogueNow() {
        return this.analogueNow.get();
    }

    @Override
    public float analoguePrev() {
        return this.analoguePrev.get();
    }

    @Override
    public boolean digitalNow() {
        return this.digitalNow.get();
    }

    @Override
    public boolean digitalPrev() {
        return this.digitalThen.get();
    }

    @Override
    public boolean justPressed() {
        return this.justPressed.get();
    }

    @Override
    public boolean justReleased() {
        return this.justReleased.get();
    }

    @Override
    public boolean justTapped() {
        return this.justTapped.get();
    }

    @Override
    public GuiPressOutput guiPressed() {
        return this.guiPressOutput;
    }

    @Override
    public <T extends DigitalOutput> T addDigitalOutput(ResourceLocation id, T output) {
        this.digitalOutputs.put(id, output);
        return output;
    }

    @Override
    public <T extends DigitalOutput> T getDigitalOutput(ResourceLocation id) {
        return (T)this.digitalOutputs.get(id);
    }

    @Override
    public <T extends AnalogueOutput> T addAnalogueOutput(ResourceLocation id, T output) {
        this.analogueOutputs.put(id, output);
        return output;
    }

    @Override
    public <T extends AnalogueOutput> T getAnalogueOutput(ResourceLocation id) {
        return (T)this.analogueOutputs.get(id);
    }

    private class StateAccessImpl
    implements StateAccess {
        private final int maxHistory;
        private boolean valid;
        @Nullable
        private final Consumer<StateAccess> pushListener;

        public StateAccessImpl(@Nullable int maxHistory, Consumer<StateAccess> pushListener) {
            this.maxHistory = maxHistory;
            this.valid = true;
            this.pushListener = pushListener;
        }

        @Override
        public float analogue(int history) {
            if (!this.valid) {
                throw new IllegalStateException("Tried to access state from returned access!");
            }
            if (history > this.maxHistory) {
                throw new IllegalStateException("Overflowing history!");
            }
            return InputBindingImpl.this.stateHistory.tail(history).floatValue();
        }

        @Override
        public boolean digital(int history) {
            return this.analogue(history) > ((InputComponent.Config)InputBindingImpl.this.controller.input().orElseThrow().confObj()).buttonActivationThreshold;
        }

        @Override
        public boolean isSuppressed() {
            return InputBindingImpl.this.suppressed;
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }

        @Override
        public int maxHistory() {
            return this.maxHistory;
        }

        public void onPush() {
            if (this.pushListener != null) {
                this.pushListener.accept(this);
            }
        }

        public void retire() {
            this.valid = false;
        }
    }
}

