/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.core;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.utils.InitialScreenRegistryDuck;
import dev.isxander.controlify.utils.MouseMinecraftCallNotifier;
import dev.isxander.controlify.utils.animation.impl.Animator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.CrashReport;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
implements InitialScreenRegistryDuck {
    @Shadow
    @Final
    public MouseHandler mouseHandler;
    @Shadow
    @Nullable
    public Screen screen;
    @Unique
    private final List<Function<Runnable, Screen>> initialScreenCallbacks = new ArrayList<Function<Runnable, Screen>>();
    @Unique
    private boolean initialScreensHappened = false;

    @Shadow
    public abstract void setScreen(@Nullable Screen var1);

    @Shadow
    public abstract DeltaTracker getTimer();

    @Unique
    public DeltaTracker getDeltaTracker() {
        return this.getTimer();
    }

    @Shadow
    public abstract void emergencySaveAndCrash(CrashReport var1);

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MouseHandler;releaseMouse()V")})
    private void notifyInjectionToNotRun(Screen screen, CallbackInfo ci) {
        ((MouseMinecraftCallNotifier)this.mouseHandler).controlify$imFromMinecraftSetScreen();
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init(Lnet/minecraft/client/Minecraft;II)V", shift=At.Shift.AFTER)})
    private void hideMouseAfterRelease(Screen screen, CallbackInfo ci) {
        if (ControlifyApi.get().currentInputMode().isController()) {
            Controlify.instance().hideMouse(true, true);
        }
    }

    @Inject(method={"onGameLoadFinished"}, at={@At(value="RETURN")})
    private void initControlifyNow(CallbackInfo ci) {
        try {
            Controlify.instance().initializeControlify();
        }
        catch (Throwable t) {
            CrashReport report = CrashReport.forThrowable((Throwable)t, (String)"Failed to initialize Controlify");
            this.emergencySaveAndCrash(report);
        }
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MouseHandler;handleAccumulatedMovement()V")})
    private void doPlayerLook(boolean tick, CallbackInfo ci) {
        Controlify.instance().inGameInputHandler().ifPresent(ih -> ih.processPlayerLook(this.getTickDelta()));
    }

    @Inject(method={"close"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/telemetry/ClientTelemetryManager;close()V")})
    private void onMinecraftClose(CallbackInfo ci) {
        Controlify.instance().getControllerManager().ifPresent(ControllerManager::close);
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;render(Lnet/minecraft/client/DeltaTracker;Z)V")})
    private void tickAnimator(boolean tick, CallbackInfo ci) {
        Animator.INSTANCE.tick(this.getTickDelta());
    }

    @ModifyVariable(method={"addInitialScreens"}, at=@At(value="TAIL"), argsOnly=true)
    private List<Function<Runnable, Screen>> injectCustomInitialScreens(List<Function<Runnable, Screen>> output) {
        output.addAll(this.initialScreenCallbacks);
        this.initialScreensHappened = true;
        return output;
    }

    @Unique
    private float getTickDelta() {
        return this.getDeltaTracker().getGameTimeDeltaTicks();
    }

    @Override
    public void controlify$registerInitialScreen(Function<Runnable, Screen> screenFactory) {
        if (this.initialScreensHappened) {
            Screen lastScreen = this.screen;
            this.setScreen(screenFactory.apply(() -> this.setScreen(lastScreen)));
        } else {
            this.initialScreenCallbacks.add(screenFactory);
        }
    }
}

