/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.mixins.feature.virtualmouse.snapping.RecipeBookComponentAccessor;
import dev.isxander.controlify.mixins.feature.virtualmouse.snapping.RecipeBookPageAccessor;
import dev.isxander.controlify.screenop.compat.vanilla.AbstractContainerScreenProcessor;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookTabButton;
import net.minecraft.world.inventory.Slot;

public class RecipeBookScreenProcessor<T extends AbstractContainerScreen<?>>
extends AbstractContainerScreenProcessor<T> {
    private final RecipeBookScreenAccessor recipeBookScreenAccessor;

    public RecipeBookScreenProcessor(T screen, RecipeBookScreenAccessor recipeBookScreenAccessor, Supplier<Slot> hoveredSlot, AbstractContainerScreenProcessor.ClickSlotFunction clickSlotFunction, Predicate<ControllerEntity> doItemSlotActions) {
        super(screen, hoveredSlot, clickSlotFunction, doItemSlotActions);
        this.recipeBookScreenAccessor = recipeBookScreenAccessor;
    }

    @Override
    protected void handleScreenVMouse(ControllerEntity controller, VirtualMouseHandler vmouse) {
        int index;
        super.handleScreenVMouse(controller, vmouse);
        RecipeBookComponent recipeBookComponent = this.recipeBookScreenAccessor.controlify$getRecipeBookComponent();
        if (!recipeBookComponent.isVisible()) {
            return;
        }
        RecipeBookComponentAccessor componentAccessor = (RecipeBookComponentAccessor)recipeBookComponent;
        RecipeBookPageAccessor pageAccessor = (RecipeBookPageAccessor)componentAccessor.getRecipeBookPage();
        List<RecipeBookTabButton> tabs = componentAccessor.getTabButtons().stream().filter(tab -> tab.visible).toList();
        RecipeBookTabButton selectedTab = componentAccessor.getSelectedTab();
        StateSwitchingButton button = null;
        if (ControlifyBindings.VMOUSE_PAGE_NEXT.on(controller).justPressed()) {
            button = pageAccessor.getForwardButton();
        }
        if (ControlifyBindings.VMOUSE_PAGE_PREV.on(controller).justPressed()) {
            button = pageAccessor.getBackButton();
        }
        if (ControlifyBindings.VMOUSE_PAGE_DOWN.on(controller).justPressed() && (index = tabs.indexOf(selectedTab)) != tabs.size() - 1) {
            button = (StateSwitchingButton)tabs.get(index + 1);
        }
        if (ControlifyBindings.VMOUSE_PAGE_UP.on(controller).justPressed() && (index = tabs.indexOf(selectedTab)) != 0) {
            button = (StateSwitchingButton)tabs.get(index - 1);
        }
        if (button != null) {
            recipeBookComponent.mouseClicked((double)button.getX(), (double)button.getY(), 0);
        }
    }

    public static interface RecipeBookScreenAccessor {
        public RecipeBookComponent controlify$getRecipeBookComponent();
    }
}

