/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.virtualmouse;

import com.mojang.blaze3d.platform.Window;
import com.mojang.datafixers.util.Pair;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.api.vmousesnapping.ISnapBehaviour;
import dev.isxander.controlify.api.vmousesnapping.SnapPoint;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.GamepadInputs;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.touchpad.TouchpadComponent;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.mixins.feature.virtualmouse.MouseHandlerAccessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.controlify.utils.ToastUtils;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.utils.render.CGuiPose;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.lwjgl.glfw.GLFW;

public class VirtualMouseHandler {
    private static final ResourceLocation CURSOR_TEXTURE = CUtil.rl("textures/gui/virtual_mouse.png");
    private double targetX;
    private double targetY;
    private double currentX;
    private double currentY;
    private double scrollX;
    private double scrollY;
    private float prevXFinger;
    private float prevYFinger;
    private final Minecraft minecraft;
    private boolean virtualMouseEnabled;
    private Set<SnapPoint> snapPoints;
    private SnapPoint lastSnappedPoint;
    private final HoldRepeatHelper holdRepeatHelper = new HoldRepeatHelper(10, 3);

    public VirtualMouseHandler() {
        this.minecraft = Minecraft.getInstance();
        this.snapPoints = this.collectSnapPoints();
        ControlifyEvents.INPUT_MODE_CHANGED.register(event -> this.onInputModeChanged(event.mode()));
    }

    public void handleControllerInput(ControllerEntity controller) {
        if (ControlifyBindings.VMOUSE_TOGGLE.on(controller).justPressed()) {
            this.toggleVirtualMouse();
        }
        if (!this.virtualMouseEnabled) {
            return;
        }
        InputComponent input = controller.input().orElseThrow();
        Optional<TouchpadComponent> touchpad = controller.touchpad();
        InputBinding moveRight = ControlifyBindings.VMOUSE_MOVE_RIGHT.on(controller);
        InputBinding moveLeft = ControlifyBindings.VMOUSE_MOVE_LEFT.on(controller);
        InputBinding moveDown = ControlifyBindings.VMOUSE_MOVE_DOWN.on(controller);
        InputBinding moveUp = ControlifyBindings.VMOUSE_MOVE_UP.on(controller);
        Vector2d impulse = ControllerUtils.applyEasingToLength(moveRight.analogueNow() - moveLeft.analogueNow(), moveDown.analogueNow() - moveUp.analogueNow(), x -> Math.pow(x, 3.0));
        Vector2d prevImpulse = ControllerUtils.applyEasingToLength(moveRight.analoguePrev() - moveLeft.analoguePrev(), moveDown.analoguePrev() - moveUp.analoguePrev(), x -> Math.pow(x, 3.0));
        this.snapPoints = this.collectSnapPoints();
        if (impulse.x == 0.0 && impulse.y == 0.0 && (prevImpulse.x != 0.0 || prevImpulse.y != 0.0)) {
            this.snapToClosestPoint();
        }
        float sensitivity = input.config().config().virtualMouseSensitivity;
        if (!((InputComponent.Config)input.confObj()).isLCE) {
            float windowSizeModifier = (float)Math.max(this.minecraft.getWindow().getWidth(), this.minecraft.getWindow().getHeight()) / 800.0f;
            this.targetX += impulse.x * 20.0 * (double)sensitivity * (double)windowSizeModifier;
            this.targetY += impulse.y * 20.0 * (double)sensitivity * (double)windowSizeModifier;
        } else {
            float windowSizeModifier = (float)this.minecraft.getWindow().getScreenWidth() / (float)this.minecraft.getWindow().getGuiScaledWidth();
            this.targetX += impulse.x * 10.0 * (double)sensitivity * (double)windowSizeModifier;
            this.targetY += impulse.y * 10.0 * (double)sensitivity * (double)windowSizeModifier;
        }
        this.targetX = Mth.clamp((double)this.targetX, (double)0.0, (double)this.minecraft.getWindow().getWidth());
        this.targetY = Mth.clamp((double)this.targetY, (double)0.0, (double)this.minecraft.getWindow().getHeight());
        this.scrollY += (double)(ControlifyBindings.VMOUSE_SCROLL_UP.on(controller).analogueNow() - ControlifyBindings.VMOUSE_SCROLL_DOWN.on(controller).analogueNow());
        if (this.holdRepeatHelper.shouldAction(ControlifyBindings.VMOUSE_SNAP_UP.on(controller))) {
            this.snapInDirection(ScreenDirection.UP);
            this.holdRepeatHelper.onNavigate();
        } else if (this.holdRepeatHelper.shouldAction(ControlifyBindings.VMOUSE_SNAP_DOWN.on(controller))) {
            this.snapInDirection(ScreenDirection.DOWN);
            this.holdRepeatHelper.onNavigate();
        } else if (this.holdRepeatHelper.shouldAction(ControlifyBindings.VMOUSE_SNAP_LEFT.on(controller))) {
            this.snapInDirection(ScreenDirection.LEFT);
            this.holdRepeatHelper.onNavigate();
        } else if (this.holdRepeatHelper.shouldAction(ControlifyBindings.VMOUSE_SNAP_RIGHT.on(controller))) {
            this.snapInDirection(ScreenDirection.RIGHT);
            this.holdRepeatHelper.onNavigate();
        }
        if (ScreenProcessorProvider.provide(this.minecraft.screen).virtualMouseBehaviour().isDefaultOr(VirtualMouseBehaviour.ENABLED)) {
            this.handleCompatibilityBinds(controller);
        }
        if (ControlifyBindings.GUI_BACK.on(controller).justPressed() && this.minecraft.screen != null) {
            ScreenProcessor.playClackSound();
            this.minecraft.screen.onClose();
        }
    }

    public void handleCompatibilityBinds(ControllerEntity controller) {
        long windowHandle = this.minecraft.getWindow().getWindow();
        InputComponent input = controller.input().orElseThrow();
        boolean touchpadPressed = input.stateNow().isButtonDown(GamepadInputs.TOUCHPAD_1_BUTTON);
        boolean prevTouchpadPressed = input.stateThen().isButtonDown(GamepadInputs.TOUCHPAD_1_BUTTON);
        if (ControlifyBindings.VMOUSE_LCLICK.on(controller).justPressed() || touchpadPressed && !prevTouchpadPressed) {
            this.simulateMousePress(0, 1, 0);
        } else if (ControlifyBindings.VMOUSE_LCLICK.on(controller).justReleased() || !touchpadPressed && prevTouchpadPressed) {
            this.simulateMousePress(0, 0, 0);
        }
        if (ControlifyBindings.VMOUSE_RCLICK.on(controller).justPressed() || touchpadPressed && !prevTouchpadPressed) {
            this.simulateMousePress(1, 1, 0);
        } else if (ControlifyBindings.VMOUSE_RCLICK.on(controller).justReleased() || !touchpadPressed && prevTouchpadPressed) {
            this.simulateMousePress(1, 0, 0);
        }
        if (ControlifyBindings.VMOUSE_SHIFT_CLICK.on(controller).justPressed()) {
            this.simulateMousePress(0, 1, 1);
        } else if (ControlifyBindings.VMOUSE_SHIFT_CLICK.on(controller).justReleased()) {
            this.simulateMousePress(0, 0, 1);
        }
    }

    private void simulateMousePress(int button, int action, int modifiers) {
        MouseHandlerAccessor mouseHandler = (MouseHandlerAccessor)this.minecraft.mouseHandler;
        long windowHandle = this.minecraft.getWindow().getWindow();
        mouseHandler.invokeOnPress(windowHandle, button, action, modifiers);
    }

    public void updateMouse() {
        if (!this.virtualMouseEnabled) {
            return;
        }
        float delta = this.minecraft.getTimer().getRealtimeDeltaTicks();
        long windowHandle = this.minecraft.getWindow().getWindow();
        if ((double)Math.round(this.targetX * 100.0) / 100.0 != (double)Math.round(this.currentX * 100.0) / 100.0 || (double)Math.round(this.targetY * 100.0) / 100.0 != (double)Math.round(this.currentY * 100.0) / 100.0) {
            this.currentX = Mth.lerp((double)delta, (double)this.currentX, (double)this.targetX);
            this.currentY = Mth.lerp((double)delta, (double)this.currentY, (double)this.targetY);
            ((MouseHandlerAccessor)this.minecraft.mouseHandler).invokeOnMove(windowHandle, this.currentX, this.currentY);
        } else {
            this.currentX = this.targetX;
            this.currentY = this.targetY;
        }
        if (Math.abs(this.scrollX) >= 0.01 || Math.abs(this.scrollY) >= 0.01) {
            double currentScrollY = this.scrollY * (double)delta;
            this.scrollY -= currentScrollY;
            double currentScrollX = this.scrollX * (double)delta;
            this.scrollX -= currentScrollX;
            ((MouseHandlerAccessor)this.minecraft.mouseHandler).invokeOnScroll(windowHandle, currentScrollX, currentScrollY);
        } else {
            this.scrollY = 0.0;
            this.scrollX = 0.0;
        }
    }

    public void snapToClosestPoint() {
        SnapPoint closestSnapPoint;
        Window window = this.minecraft.getWindow();
        Vector2d scaleFactor = new Vector2d((double)window.getGuiScaledWidth() / (double)window.getScreenWidth(), (double)window.getGuiScaledHeight() / (double)window.getScreenHeight());
        Vector2d target = new Vector2d(this.targetX, this.targetY).mul((Vector2dc)scaleFactor);
        if (this.lastSnappedPoint != null && this.lastSnappedPoint.position().distanceSquared((Vector2ic)new Vector2i((Vector2dc)target, 2)) > (long)this.lastSnappedPoint.range() * (long)this.lastSnappedPoint.range()) {
            this.lastSnappedPoint = null;
        }
        if ((closestSnapPoint = (SnapPoint)this.snapPoints.stream().filter(snapPoint -> !snapPoint.equals(this.lastSnappedPoint)).map(snapPoint -> new Pair(snapPoint, (Object)snapPoint.position().distanceSquared((Vector2ic)new Vector2i((Vector2dc)target, 2)))).filter(point -> (Long)point.getSecond() <= (long)((SnapPoint)point.getFirst()).range() * (long)((SnapPoint)point.getFirst()).range()).min(Comparator.comparingLong(Pair::getSecond)).orElse(new Pair(null, (Object)Long.MAX_VALUE)).getFirst()) != null) {
            this.snapToPoint(closestSnapPoint, (Vector2dc)scaleFactor);
        }
    }

    public void snapInDirection(ScreenDirection direction) {
        Window window = this.minecraft.getWindow();
        Vector2d scaleFactor = new Vector2d((double)window.getGuiScaledWidth() / (double)window.getScreenWidth(), (double)window.getGuiScaledHeight() / (double)window.getScreenHeight());
        Vector2d target = new Vector2d(this.targetX, this.targetY).mul((Vector2dc)scaleFactor);
        Optional<SnapPoint> closestSnapPoint = VirtualMouseHandler.findOrthogonalSnapPoint(this.lastSnappedPoint, direction, target, this.snapPoints).or(() -> {
            Vector2d orthogonalTarget = new Vector2d((Vector2dc)target);
            switch (direction) {
                case UP: {
                    orthogonalTarget.y = window.getGuiScaledHeight();
                    break;
                }
                case DOWN: {
                    orthogonalTarget.y = 0.0;
                    break;
                }
                case LEFT: {
                    orthogonalTarget.x = window.getGuiScaledWidth();
                    break;
                }
                case RIGHT: {
                    orthogonalTarget.x = 0.0;
                }
            }
            return VirtualMouseHandler.findOrthogonalSnapPoint(this.lastSnappedPoint, direction, orthogonalTarget, this.snapPoints);
        });
        closestSnapPoint.ifPresent(snapPoint -> this.snapToPoint((SnapPoint)snapPoint, (Vector2dc)scaleFactor));
    }

    private static Optional<SnapPoint> findOrthogonalSnapPoint(SnapPoint from, ScreenDirection direction, Vector2d target, Collection<SnapPoint> snapPoints) {
        return snapPoints.stream().filter(snapPoint -> !snapPoint.equals(from)).map(snapPoint -> new Pair(snapPoint, (Object)new Vector2d((double)snapPoint.position().x() - target.x(), (double)snapPoint.position().y() - target.y()))).filter(pair -> {
            Vector2d dist = (Vector2d)pair.getSecond();
            double axis = direction.getAxis() == ScreenAxis.HORIZONTAL ? dist.x : dist.y;
            double positive = direction.isPositive() ? 1.0 : -1.0;
            return axis * positive > 0.0;
        }).filter(pair -> {
            SnapPoint snapPoint = (SnapPoint)pair.getFirst();
            Vector2d dist = (Vector2d)pair.getSecond();
            double distance = Math.abs(direction.getAxis() == ScreenAxis.HORIZONTAL ? dist.x : dist.y);
            double deviation = Math.abs(direction.getAxis() == ScreenAxis.HORIZONTAL ? dist.y : dist.x);
            ((Vector2d)pair.getSecond()).set(distance, deviation * 4.0);
            return distance >= (double)snapPoint.range() && deviation < distance * 2.0;
        }).min(Comparator.comparingDouble(pair -> {
            Vector2d distDev = (Vector2d)pair.getSecond();
            return distDev.x + distDev.y;
        })).map(Pair::getFirst);
    }

    public void snapToPoint(SnapPoint snapPoint, Vector2dc scaleFactor) {
        this.lastSnappedPoint = snapPoint;
        this.targetX = this.currentX = (double)snapPoint.position().x() / scaleFactor.x();
        this.targetY = this.currentY = (double)snapPoint.position().y() / scaleFactor.y();
        long windowHandle = this.minecraft.getWindow().getWindow();
        ((MouseHandlerAccessor)this.minecraft.mouseHandler).invokeOnMove(windowHandle, this.currentX, this.currentY);
    }

    public void onScreenChanged() {
        long windowHandle = this.minecraft.getWindow().getWindow();
        if (this.minecraft.screen != null) {
            if (this.requiresVirtualMouse()) {
                this.enableVirtualMouse();
            } else {
                this.disableVirtualMouse();
            }
            if (Controlify.instance().currentInputMode().isController()) {
                GLFW.glfwSetInputMode((long)windowHandle, (int)208897, (int)212994);
            }
        } else if (this.virtualMouseEnabled) {
            this.disableVirtualMouse();
            this.minecraft.mouseHandler.grabMouse();
        }
    }

    public void onInputModeChanged(InputMode mode) {
        if (mode.isController()) {
            if (this.requiresVirtualMouse()) {
                this.enableVirtualMouse();
            }
        } else if (this.virtualMouseEnabled) {
            this.disableVirtualMouse();
        }
    }

    public void renderVirtualMouse(GuiGraphics graphics) {
        if (!this.virtualMouseEnabled) {
            return;
        }
        if (DebugProperties.DEBUG_SNAPPING) {
            for (SnapPoint snapPoint : this.snapPoints) {
                graphics.fill(snapPoint.position().x() - snapPoint.range(), snapPoint.position().y() - snapPoint.range(), snapPoint.position().x() + snapPoint.range(), snapPoint.position().y() + snapPoint.range(), 0x33FFFFFF);
                graphics.fill(snapPoint.position().x() - 1, snapPoint.position().y() - 1, snapPoint.position().x() + 1, snapPoint.position().y() + 1, snapPoint.equals(this.lastSnappedPoint) ? -256 : -65536);
            }
        }
        double scaledX = this.currentX * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
        double scaledY = this.currentY * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight();
        CGuiPose pose = CGuiPose.ofPush(graphics);
        pose.translate((float)scaledX, (float)scaledY);
        pose.nextLayer(1000.0f);
        pose.scale(0.5f, 0.5f);
        Blit.tex(graphics, CURSOR_TEXTURE, -16, -16, 0, 0, 32, 32, 32, 32);
        pose.pop();
    }

    public void enableVirtualMouse() {
        if (this.virtualMouseEnabled) {
            return;
        }
        long windowHandle = this.minecraft.getWindow().getWindow();
        GLFW.glfwSetInputMode((long)windowHandle, (int)208897, (int)212995);
        this.virtualMouseEnabled = true;
        if (this.minecraft.mouseHandler.xpos() == -50.0 && this.minecraft.mouseHandler.ypos() == -50.0) {
            this.targetX = this.currentX = (double)((float)this.minecraft.getWindow().getScreenWidth() / 2.0f);
            this.targetY = this.currentY = (double)((float)this.minecraft.getWindow().getScreenHeight() / 2.0f);
        } else {
            this.targetX = this.currentX = this.minecraft.mouseHandler.xpos();
            this.targetY = this.currentY = this.minecraft.mouseHandler.ypos();
        }
        this.setMousePosition();
        ControlifyEvents.VIRTUAL_MOUSE_TOGGLED.invoke(new ControlifyEvents.VirtualMouseToggled(true));
        if (this.minecraft.screen != null) {
            ScreenProcessorProvider.provide(this.minecraft.screen).onVirtualMouseToggled(true);
        }
    }

    public void disableVirtualMouse() {
        if (!this.virtualMouseEnabled) {
            return;
        }
        long windowHandle = this.minecraft.getWindow().getWindow();
        ((MouseHandlerAccessor)this.minecraft.mouseHandler).setMouseGrabbed(false);
        Controlify.instance().hideMouse(true, true);
        GLFW.glfwSetInputMode((long)windowHandle, (int)208897, (int)212993);
        this.setMousePosition();
        this.virtualMouseEnabled = false;
        this.targetX = this.currentX = this.minecraft.mouseHandler.xpos();
        this.targetY = this.currentY = this.minecraft.mouseHandler.ypos();
        ControlifyEvents.VIRTUAL_MOUSE_TOGGLED.invoke(new ControlifyEvents.VirtualMouseToggled(false));
        if (this.minecraft.screen != null) {
            ScreenProcessorProvider.provide(this.minecraft.screen).onVirtualMouseToggled(false);
        }
    }

    private void setMousePosition() {
        GLFW.glfwSetCursorPos((long)this.minecraft.getWindow().getWindow(), (double)this.targetX, (double)this.targetY);
    }

    public boolean requiresVirtualMouse() {
        boolean hasScreen;
        boolean isController = Controlify.instance().currentInputMode().isController();
        boolean bl = hasScreen = this.minecraft.screen != null;
        if (isController && hasScreen) {
            return switch (ScreenProcessorProvider.provide(this.minecraft.screen).virtualMouseBehaviour()) {
                default -> throw new MatchException(null, null);
                case VirtualMouseBehaviour.DEFAULT -> Controlify.instance().config().globalSettings().virtualMouseScreens.stream().anyMatch(s -> s.isAssignableFrom(this.minecraft.screen.getClass()));
                case VirtualMouseBehaviour.ENABLED, VirtualMouseBehaviour.CURSOR_ONLY -> true;
                case VirtualMouseBehaviour.DISABLED -> false;
            };
        }
        return false;
    }

    public void toggleVirtualMouse() {
        if (this.minecraft.screen == null) {
            return;
        }
        if (ScreenProcessorProvider.provide(this.minecraft.screen).virtualMouseBehaviour() != VirtualMouseBehaviour.DEFAULT) {
            ToastUtils.sendToast((Component)Component.translatable((String)"controlify.toast.vmouse_unavailable.title"), (Component)Component.translatable((String)"controlify.toast.vmouse_unavailable.description"), false);
            return;
        }
        List<Class<?>> screens = Controlify.instance().config().globalSettings().virtualMouseScreens;
        Class<?> screenClass = this.minecraft.screen.getClass();
        if (screens.contains(screenClass)) {
            screens.remove(screenClass);
            this.disableVirtualMouse();
            Controlify.instance().hideMouse(true, false);
            ToastUtils.sendToast((Component)Component.translatable((String)"controlify.toast.vmouse_disabled.title"), (Component)Component.translatable((String)"controlify.toast.vmouse_disabled.description"), false);
        } else {
            screens.add(screenClass);
            this.enableVirtualMouse();
            ToastUtils.sendToast((Component)Component.translatable((String)"controlify.toast.vmouse_enabled.title"), (Component)Component.translatable((String)"controlify.toast.vmouse_enabled.description"), false);
        }
        Controlify.instance().config().save();
    }

    public boolean isVirtualMouseEnabled() {
        return this.virtualMouseEnabled;
    }

    public int getCurrentX(float deltaTime) {
        return (int)Mth.lerp((double)deltaTime, (double)this.currentX, (double)this.targetX);
    }

    public int getCurrentY(float deltaTime) {
        return (int)Mth.lerp((double)deltaTime, (double)this.currentY, (double)this.targetY);
    }

    public void preventScrollingThisTick() {
        this.scrollX = 0.0;
        this.scrollY = 0.0;
    }

    private Set<SnapPoint> collectSnapPoints() {
        Screen screen = this.minecraft.screen;
        if (screen instanceof ISnapBehaviour) {
            ISnapBehaviour snapBehaviour = (ISnapBehaviour)screen;
            HashSet<SnapPoint> points = new HashSet<SnapPoint>();
            snapBehaviour.controlify$collectSnapPoints(points::add);
            return points;
        }
        return Set.of();
    }
}

