/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.ingame;

import dev.isxander.controlify.ingame.InGameInputHandler;
import net.minecraft.client.player.Input;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.Validate;

public class DualInput
extends Input {
    private final Input input1;
    private final Input input2;

    public DualInput(Input input1, Input input2) {
        Validate.isTrue((!(input1 instanceof DualInput) ? 1 : 0) != 0, (String)"Cannot nest DualInputs", (Object[])new Object[0]);
        Validate.isTrue((!(input2 instanceof DualInput) ? 1 : 0) != 0, (String)"Cannot nest DualInputs", (Object[])new Object[0]);
        this.input1 = input1;
        this.input2 = input2;
    }

    public void tick(boolean slowDown, float movementMultiplier) {
        this.input1.tick(slowDown, movementMultiplier);
        this.input2.tick(slowDown, movementMultiplier);
        Vec2 input1MoveVec = InGameInputHandler.getMoveVec(this.input1);
        Vec2 input2MoveVec = InGameInputHandler.getMoveVec(this.input2);
        this.setMoveVec(Mth.clamp((float)(input1MoveVec.y + input2MoveVec.y), (float)-1.0f, (float)1.0f), Mth.clamp((float)(input1MoveVec.x + input2MoveVec.x), (float)-1.0f, (float)1.0f));
        this.left = this.input1.left || this.input2.left;
        this.right = this.input1.right || this.input2.right;
        this.up = this.input1.up || this.input2.up;
        this.down = this.input1.down || this.input2.down;
        this.jumping = this.input1.jumping || this.input2.jumping;
        this.shiftKeyDown = this.input1.shiftKeyDown || this.input2.shiftKeyDown;
    }

    private void setMoveVec(float forward, float left) {
        this.forwardImpulse = forward;
        this.leftImpulse = left;
    }
}

