/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public final class ColorUtils {
    public static int lerpARGB(float delta, int start, int end) {
        return FastColor.ARGB32.lerp((float)delta, (int)start, (int)end);
    }

    public static int argbRed(int argb) {
        return FastColor.ARGB32.red((int)argb);
    }

    public static int argbGreen(int argb) {
        return FastColor.ARGB32.green((int)argb);
    }

    public static int argbBlue(int argb) {
        return FastColor.ARGB32.blue((int)argb);
    }

    public static int argbAlpha(int argb) {
        return FastColor.ARGB32.alpha((int)argb);
    }

    public static float[] decomposeARGBFloat(int argb) {
        return new float[]{(float)FastColor.ARGB32.alpha((int)argb) / 255.0f, (float)FastColor.ARGB32.red((int)argb) / 255.0f, (float)FastColor.ARGB32.green((int)argb) / 255.0f, (float)FastColor.ARGB32.blue((int)argb) / 255.0f};
    }

    public static int grey(float brightness, float alpha) {
        int component = Mth.floor((float)(brightness * 255.0f));
        int color = Mth.floor((float)(alpha * 255.0f));
        color = color << 8 | component;
        color = color << 8 | component;
        color = color << 8 | component;
        return color;
    }
}

