/*
 * Decompiled with CFR 0.152.
 */
package com.rijz.truefullbright;

import com.rijz.truefullbright.FullbrightCommands;
import com.rijz.truefullbright.FullbrightConfig;
import com.rijz.truefullbright.KeybindHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrueFullbrightMod
implements ClientModInitializer {
    public static final String MOD_ID = "truefullbright";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"TrueFullbright");
    private static long lastConfigCheck = 0L;
    private static final long CONFIG_CHECK_INTERVAL = 50L;

    public void onInitializeClient() {
        LOGGER.info("Initializing True Fullbright v{}", (Object)this.getModVersion());
        try {
            FullbrightConfig.load();
            KeybindHandler.init();
            FullbrightCommands.register();
            this.initializeDefaultGammaAsync();
            ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
            LOGGER.info("True Fullbright initialized successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize True Fullbright", (Throwable)e);
        }
    }

    private void onClientTick(class_310 client) {
        try {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastConfigCheck < 50L) {
                return;
            }
            lastConfigCheck = currentTime;
            FullbrightConfig config = FullbrightConfig.get();
            class_746 player = client.field_1724;
            if (client.field_1690 == null || client.field_1687 == null || player == null) {
                return;
            }
            this.handleFullbrightLogic(client, config, player);
            if (config.isDirty() && currentTime - config.getLastSaveTime() > 5000L) {
                FullbrightConfig.save();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in client tick handler", (Throwable)e);
        }
    }

    private void handleFullbrightLogic(class_310 client, FullbrightConfig config, class_746 player) {
        if (config.useNightVision) {
            this.handleNightVisionMode(client, config, player);
        } else if (config.useGamma) {
            this.handleGammaMode(client, config, player);
        } else {
            this.handleDisabledMode(client, config, player);
        }
    }

    private void handleGammaMode(class_310 client, FullbrightConfig config, class_746 player) {
        client.field_1690.method_42473().method_41748((Object)config.brightness);
        if (player.method_6059(class_1294.field_5925)) {
            player.method_6016(class_1294.field_5925);
        }
    }

    private void handleNightVisionMode(class_310 client, FullbrightConfig config, class_746 player) {
        client.field_1690.method_42473().method_41748((Object)config.defaultGamma);
        class_1293 currentEffect = player.method_6112(class_1294.field_5925);
        if (currentEffect == null || currentEffect.method_5584() < 200) {
            player.method_6092(new class_1293(class_1294.field_5925, Integer.MAX_VALUE, 0, false, false, false));
        }
    }

    private void handleDisabledMode(class_310 client, FullbrightConfig config, class_746 player) {
        client.field_1690.method_42473().method_41748((Object)config.defaultGamma);
        if (player.method_6059(class_1294.field_5925)) {
            player.method_6016(class_1294.field_5925);
        }
    }

    private void initializeDefaultGammaAsync() {
        CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS).execute(() -> {
            try {
                class_310 client = class_310.method_1551();
                if (client.field_1690 != null) {
                    FullbrightConfig config = FullbrightConfig.get();
                    if (config.defaultGamma == 1.0) {
                        config.defaultGamma = (Double)client.field_1690.method_42473().method_41753();
                        config.markDirty();
                        FullbrightConfig.save();
                        LOGGER.debug("Initialized default gamma value: {}", (Object)config.defaultGamma);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Could not initialize default gamma value", (Throwable)e);
            }
        });
    }

    private String getModVersion() {
        try {
            return FabricLoader.getInstance().getModContainer(MOD_ID).map(mod -> mod.getMetadata().getVersion().getFriendlyString()).orElse("Unknown");
        }
        catch (Exception e) {
            return "Unknown";
        }
    }
}

