/*
 * Decompiled with CFR 0.152.
 */
package com.rijz.truefullbright;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.rijz.truefullbright.FullbrightConfig;
import com.rijz.truefullbright.FullbrightConfigScreen;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class FullbrightCommands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> FullbrightCommands.register((CommandDispatcher<class_2168>)dispatcher));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fullbright").executes(ctx -> FullbrightCommands.showStatus((CommandContext<class_2168>)ctx))).then(class_2170.method_9247((String)"toggle").executes(ctx -> {
            String statusText;
            FullbrightConfig config = FullbrightConfig.get();
            boolean wasEnabled = config.isFullbrightEnabled();
            String oldMode = config.useNightVision ? "Night Vision" : (config.useGamma ? "Gamma" : "Disabled");
            boolean newState = FullbrightCommands.toggle();
            String newMode = config.useNightVision ? "Night Vision" : (config.useGamma ? "Gamma" : "Disabled");
            String string = statusText = newState ? "ON" : "OFF";
            if (newState) {
                FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.toggled_on", statusText, newMode);
            } else {
                FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.toggled_off", statusText);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mode").then(class_2170.method_9247((String)"gamma").executes(ctx -> {
            FullbrightCommands.setMode(false);
            FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.mode.gamma", new Object[0]);
            return 1;
        }))).then(class_2170.method_9247((String)"nightvision").executes(ctx -> {
            FullbrightCommands.setMode(true);
            FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.mode.nightvision", new Object[0]);
            return 1;
        }))).then(class_2170.method_9247((String)"off").executes(ctx -> {
            FullbrightConfig config = FullbrightConfig.get();
            config.useGamma = false;
            config.useNightVision = false;
            config.markDirty();
            FullbrightConfig.save();
            FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.mode.disabled", new Object[0]);
            return 1;
        })))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(ctx -> {
            double value = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
            FullbrightCommands.setBrightness(value);
            FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.set", value);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"increase").executes(ctx -> {
            FullbrightConfig config = FullbrightConfig.get();
            if (!config.useGamma) {
                FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.error.gamma_only", new Object[0]);
                return 0;
            }
            double oldValue = config.brightness;
            FullbrightCommands.increase(0.0);
            double newValue = config.brightness;
            FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.increased", newValue);
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(ctx -> {
            FullbrightConfig config = FullbrightConfig.get();
            if (!config.useGamma) {
                FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.error.gamma_only", new Object[0]);
                return 0;
            }
            double val = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
            double oldValue = config.brightness;
            FullbrightCommands.increase(val);
            double newValue = config.brightness;
            FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.increased_by", val, newValue);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"decrease").executes(ctx -> {
            FullbrightConfig config = FullbrightConfig.get();
            if (!config.useGamma) {
                FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.error.gamma_only", new Object[0]);
                return 0;
            }
            double oldValue = config.brightness;
            FullbrightCommands.decrease(0.0);
            double newValue = config.brightness;
            FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.decreased", newValue);
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(ctx -> {
            FullbrightConfig config = FullbrightConfig.get();
            if (!config.useGamma) {
                FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.error.gamma_only", new Object[0]);
                return 0;
            }
            double val = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
            double oldValue = config.brightness;
            FullbrightCommands.decrease(val);
            double newValue = config.brightness;
            FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.decreased_by", val, newValue);
            return 1;
        })))).then(class_2170.method_9247((String)"max").executes(ctx -> {
            FullbrightCommands.setMax();
            double maxValue = FullbrightConfig.get().maxBrightness;
            FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.max", maxValue);
            return 1;
        }))).then(class_2170.method_9247((String)"min").executes(ctx -> {
            FullbrightCommands.setMin();
            double minValue = FullbrightConfig.get().minBrightness;
            FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.min", minValue);
            return 1;
        }))).then(class_2170.method_9247((String)"status").executes(FullbrightCommands::showStatus))).then(class_2170.method_9247((String)"saveconfig").executes(ctx -> {
            FullbrightConfig.save();
            FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.saved", new Object[0]);
            return 1;
        }))).then(class_2170.method_9247((String)"resetconfig").executes(ctx -> {
            FullbrightConfig.reset();
            FullbrightCommands.sendFeedback((CommandContext<class_2168>)ctx, "message.truefullbright.reset", new Object[0]);
            return 1;
        }))).then(class_2170.method_9247((String)"config").executes(ctx -> {
            FullbrightCommands.openConfigScreen();
            return 1;
        })));
    }

    private static int showStatus(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String status;
        FullbrightConfig config = FullbrightConfig.get();
        String string = status = config.isFullbrightEnabled() ? "ON" : "OFF";
        String mode = config.useNightVision ? "Night Vision" : (config.useGamma ? "Gamma" : "Disabled");
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"message.truefullbright.status", (Object[])new Object[]{status, mode, config.brightness, config.getEffectiveGamma()}), false);
        return 1;
    }

    private static void sendFeedback(CommandContext<class_2168> ctx, String translationKey, Object ... args) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)translationKey, (Object[])args), false);
    }

    private static void openConfigScreen() {
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            class_437 current = client.field_1755;
            client.method_1507(FullbrightConfigScreen.create(current));
        });
    }

    public static boolean toggle() {
        FullbrightConfig config = FullbrightConfig.get();
        if (config.useNightVision) {
            config.useNightVision = !config.useNightVision;
        } else {
            config.useGamma = !config.useGamma;
        }
        config.markDirty();
        FullbrightConfig.save();
        return config.useGamma || config.useNightVision;
    }

    public static void setMode(boolean useNightVision) {
        FullbrightConfig config = FullbrightConfig.get();
        if (useNightVision) {
            config.useNightVision = true;
            config.useGamma = false;
        } else {
            config.useGamma = true;
            config.useNightVision = false;
        }
        config.markDirty();
        FullbrightConfig.save();
    }

    public static void setBrightness(double value) {
        FullbrightConfig config = FullbrightConfig.get();
        config.setBrightness(value);
        FullbrightConfig.save();
    }

    public static void increase(double val) {
        FullbrightConfig config = FullbrightConfig.get();
        config.increaseBrightness(val);
        FullbrightConfig.save();
    }

    public static void decrease(double val) {
        FullbrightConfig config = FullbrightConfig.get();
        config.decreaseBrightness(val);
        FullbrightConfig.save();
    }

    public static void setMax() {
        FullbrightConfig config = FullbrightConfig.get();
        config.setBrightness(config.maxBrightness);
        FullbrightConfig.save();
    }

    public static void setMin() {
        FullbrightConfig config = FullbrightConfig.get();
        config.setBrightness(config.minBrightness);
        FullbrightConfig.save();
    }
}

