/*
 * Decompiled with CFR 0.152.
 */
package com.rijz.truefullbright;

import com.rijz.truefullbright.FullbrightCommands;
import com.rijz.truefullbright.FullbrightConfig;
import com.rijz.truefullbright.FullbrightConfigScreen;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeybindHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"TrueFullbright/Keybinds");
    private static final class_304.class_11900 TRUE_FULLBRIGHT_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"truefullbright", (String)"main"));
    private static class_304 toggleKey;
    private static class_304 increaseKey;
    private static class_304 decreaseKey;
    private static class_304 maxKey;
    private static class_304 minKey;
    private static class_304 configKey;
    private static long lastActionTime;
    private static final long KEY_COOLDOWN = 50L;

    public static void init() {
        try {
            toggleKey = KeybindHandler.register("toggle", 66);
            increaseKey = KeybindHandler.register("increase", 265);
            decreaseKey = KeybindHandler.register("decrease", 264);
            maxKey = KeybindHandler.register("max", 269);
            minKey = KeybindHandler.register("min", 268);
            configKey = KeybindHandler.register("config", -1);
            ClientTickEvents.END_CLIENT_TICK.register(KeybindHandler::handleKeyPresses);
            LOGGER.info("Keybindings initialized successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize keybindings", (Throwable)e);
        }
    }

    private static void handleKeyPresses(class_310 client) {
        try {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastActionTime < 50L) {
                return;
            }
            if (client.field_1724 == null || client.field_1755 != null) {
                return;
            }
            boolean actionPerformed = false;
            if (toggleKey.method_1436()) {
                String statusText;
                FullbrightConfig config = FullbrightConfig.get();
                boolean wasEnabled = config.isFullbrightEnabled();
                String oldMode = config.useNightVision ? "Night Vision" : (config.useGamma ? "Gamma" : "Disabled");
                boolean newState = FullbrightCommands.toggle();
                String newMode = config.useNightVision ? "Night Vision" : (config.useGamma ? "Gamma" : "Disabled");
                String string = statusText = newState ? "ON" : "OFF";
                if (newState) {
                    KeybindHandler.sendActionFeedback("message.truefullbright.toggled_on", statusText, newMode);
                } else {
                    KeybindHandler.sendActionFeedback("message.truefullbright.toggled_off", statusText);
                }
                actionPerformed = true;
            } else if (increaseKey.method_1436()) {
                FullbrightConfig config = FullbrightConfig.get();
                if (!config.useGamma) {
                    KeybindHandler.sendActionFeedback("message.truefullbright.error.gamma_only");
                } else {
                    double oldValue = config.brightness;
                    FullbrightCommands.increase(0.0);
                    double newValue = config.brightness;
                    KeybindHandler.sendActionFeedback("message.truefullbright.increased", newValue);
                }
                actionPerformed = true;
            } else if (decreaseKey.method_1436()) {
                FullbrightConfig config = FullbrightConfig.get();
                if (!config.useGamma) {
                    KeybindHandler.sendActionFeedback("message.truefullbright.error.gamma_only");
                } else {
                    double oldValue = config.brightness;
                    FullbrightCommands.decrease(0.0);
                    double newValue = config.brightness;
                    KeybindHandler.sendActionFeedback("message.truefullbright.decreased", newValue);
                }
                actionPerformed = true;
            } else if (maxKey.method_1436()) {
                FullbrightCommands.setMax();
                double maxValue = FullbrightConfig.get().maxBrightness;
                KeybindHandler.sendActionFeedback("message.truefullbright.max", maxValue);
                actionPerformed = true;
            } else if (minKey.method_1436()) {
                FullbrightCommands.setMin();
                double minValue = FullbrightConfig.get().minBrightness;
                KeybindHandler.sendActionFeedback("message.truefullbright.min", minValue);
                actionPerformed = true;
            } else if (configKey.method_1436()) {
                KeybindHandler.openConfigScreen();
                actionPerformed = true;
            }
            if (actionPerformed) {
                lastActionTime = currentTime;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error handling key presses", (Throwable)e);
        }
    }

    private static class_304 register(String id, int defaultKey) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.truefullbright." + id, class_3675.class_307.field_1668, defaultKey, TRUE_FULLBRIGHT_CATEGORY));
    }

    private static void sendActionFeedback(String translationKey) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            class_5250 message = class_2561.method_43471((String)translationKey);
            client.field_1724.method_7353((class_2561)message, true);
            LOGGER.debug("Keybind action: {}", (Object)translationKey);
        }
    }

    private static void sendActionFeedback(String translationKey, Object ... args) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            class_5250 message = class_2561.method_43469((String)translationKey, (Object[])args);
            client.field_1724.method_7353((class_2561)message, true);
            LOGGER.debug("Keybind action: {} with args: {}", (Object)translationKey, (Object)args);
        }
    }

    private static void openConfigScreen() {
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            block2: {
                try {
                    client.method_1507(FullbrightConfigScreen.create(client.field_1755));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to open config screen", (Throwable)e);
                    if (client.field_1724 == null) break block2;
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Failed to open config screen").method_27692(class_124.field_1061), true);
                }
            }
        });
    }

    public static String getKeybindInfo() {
        StringBuilder info = new StringBuilder();
        info.append("Fullbright Keybinds:\n");
        info.append("Toggle: ").append(toggleKey.method_16007().getString()).append("\n");
        info.append("Increase: ").append(increaseKey.method_16007().getString()).append("\n");
        info.append("Decrease: ").append(decreaseKey.method_16007().getString()).append("\n");
        info.append("Max: ").append(maxKey.method_16007().getString()).append("\n");
        info.append("Min: ").append(minKey.method_16007().getString()).append("\n");
        info.append("Config: ").append(configKey.method_16007().getString());
        return info.toString();
    }

    public static class_304 getToggleKey() {
        return toggleKey;
    }

    public static class_304 getIncreaseKey() {
        return increaseKey;
    }

    public static class_304 getDecreaseKey() {
        return decreaseKey;
    }

    public static class_304 getMaxKey() {
        return maxKey;
    }

    public static class_304 getMinKey() {
        return minKey;
    }

    public static class_304 getConfigKey() {
        return configKey;
    }

    static {
        lastActionTime = 0L;
    }
}

