/*
 * Decompiled with CFR 0.152.
 */
package com.rijz.truefullbright;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullbrightConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"TrueFullbright");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("truefullbright.json");
    private static final Path BACKUP_FILE = CONFIG_DIR.resolve("truefullbright.json.backup");
    private static FullbrightConfig INSTANCE = new FullbrightConfig();
    public boolean useGamma = false;
    public boolean useNightVision = false;
    public boolean showTooltips = true;
    public double brightness = 15.0;
    public double defaultGamma = 1.0;
    public double step = 1.0;
    public double minBrightness = 0.0;
    public double maxBrightness = 100.0;
    private transient boolean isDirty = false;
    private transient long lastSaveTime = 0L;

    public static FullbrightConfig get() {
        return INSTANCE;
    }

    public static void load() {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
                String content = Files.readString(CONFIG_FILE);
                FullbrightConfig loaded = (FullbrightConfig)GSON.fromJson(content, FullbrightConfig.class);
                if (loaded != null) {
                    loaded.validate();
                    INSTANCE = loaded;
                    LOGGER.info("Successfully loaded configuration from {}", (Object)CONFIG_FILE);
                } else {
                    LOGGER.warn("Config file was empty or invalid, using defaults");
                }
            } else {
                LOGGER.info("Config file not found, creating default configuration");
                FullbrightConfig.save();
            }
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Invalid JSON in config file, attempting to restore from backup", (Throwable)e);
            FullbrightConfig.restoreFromBackup();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load configuration", (Throwable)e);
        }
    }

    public static void save() {
        try {
            INSTANCE.validate();
            if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
                Files.copy(CONFIG_FILE, BACKUP_FILE, StandardCopyOption.REPLACE_EXISTING);
            }
            String json = GSON.toJson((Object)INSTANCE);
            Files.writeString(CONFIG_FILE, (CharSequence)json, new OpenOption[0]);
            FullbrightConfig.INSTANCE.isDirty = false;
            FullbrightConfig.INSTANCE.lastSaveTime = System.currentTimeMillis();
            LOGGER.debug("Configuration saved successfully");
        }
        catch (IOException e) {
            LOGGER.error("Failed to save configuration", (Throwable)e);
        }
    }

    public static void reset() {
        LOGGER.info("Resetting configuration to defaults");
        INSTANCE = new FullbrightConfig();
        FullbrightConfig.save();
    }

    private static void restoreFromBackup() {
        try {
            if (Files.exists(BACKUP_FILE, new LinkOption[0])) {
                Files.copy(BACKUP_FILE, CONFIG_FILE, StandardCopyOption.REPLACE_EXISTING);
                FullbrightConfig.load();
                LOGGER.info("Successfully restored configuration from backup");
            } else {
                LOGGER.warn("No backup file found, using default configuration");
                FullbrightConfig.reset();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to restore from backup, using defaults", (Throwable)e);
            FullbrightConfig.reset();
        }
    }

    private void validate() {
        this.brightness = Math.max(0.0, Math.min(100.0, this.brightness));
        this.defaultGamma = Math.max(0.0, Math.min(100.0, this.defaultGamma));
        this.step = Math.max(0.1, Math.min(100.0, this.step));
        this.minBrightness = Math.max(0.0, Math.min(100.0, this.minBrightness));
        this.maxBrightness = Math.max(1.0, Math.min(100.0, this.maxBrightness));
        if (this.minBrightness > this.maxBrightness) {
            double temp = this.minBrightness;
            this.minBrightness = this.maxBrightness;
            this.maxBrightness = temp;
        }
        this.brightness = Math.max(this.minBrightness, Math.min(this.maxBrightness, this.brightness));
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public long getLastSaveTime() {
        return this.lastSaveTime;
    }

    public boolean isFullbrightEnabled() {
        return this.useGamma || this.useNightVision;
    }

    public double getEffectiveGamma() {
        if (this.useNightVision) {
            return this.defaultGamma;
        }
        if (this.useGamma) {
            return this.brightness;
        }
        return this.defaultGamma;
    }

    public void setBrightness(double brightness) {
        double newBrightness = Math.max(this.minBrightness, Math.min(this.maxBrightness, brightness));
        if (this.brightness != newBrightness) {
            this.brightness = newBrightness;
            this.markDirty();
        }
    }

    public void increaseBrightness(double amount) {
        this.setBrightness(this.brightness + (amount > 0.0 ? amount : this.step));
    }

    public void decreaseBrightness(double amount) {
        this.setBrightness(this.brightness - (amount > 0.0 ? amount : this.step));
    }
}

