/*
 * Decompiled with CFR 0.152.
 */
package com.rijz.truefullbright;

import com.rijz.truefullbright.FullbrightConfig;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullbrightConfigScreen {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"TrueFullbright/Config");

    public static class_437 create(class_437 parent) {
        try {
            FullbrightConfig config = FullbrightConfig.get();
            boolean showTips = config.showTooltips;
            return YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"config.truefullbright.title")).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.category.main")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.enabled")).description(showTips ? OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.truefullbright.enabled.tooltip")}) : OptionDescription.of((class_2561[])new class_2561[0])).binding((Object)false, () -> config.useGamma, val -> {
                config.useGamma = val;
                if (val.booleanValue()) {
                    config.useNightVision = false;
                }
                config.markDirty();
            }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.use_night_vision")).description(showTips ? OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.truefullbright.use_night_vision.tooltip")}) : OptionDescription.of((class_2561[])new class_2561[0])).binding((Object)false, () -> config.useNightVision, val -> {
                config.useNightVision = val;
                if (val.booleanValue()) {
                    config.useGamma = false;
                }
                config.markDirty();
            }).controller(TickBoxControllerBuilder::create).build()).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.category.gamma")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.brightness")).description(showTips ? OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.truefullbright.brightness.tooltip")}) : OptionDescription.of((class_2561[])new class_2561[0])).binding((Object)15.0, () -> config.brightness, val -> config.setBrightness((double)val)).controller(opt -> ((DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)0.0, (Number)100.0)).step((Number)0.1)).formatValue(v -> class_2561.method_43470((String)String.format("%.1f", v)))).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.default_gamma")).description(showTips ? OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.truefullbright.default_gamma.tooltip")}) : OptionDescription.of((class_2561[])new class_2561[0])).binding((Object)1.0, () -> config.defaultGamma, val -> {
                config.defaultGamma = Math.max(0.0, Math.min(100.0, val));
                config.markDirty();
            }).controller(opt -> ((DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)0.0, (Number)100.0)).step((Number)0.1)).formatValue(v -> class_2561.method_43470((String)String.format("%.1f", v)))).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.step")).description(showTips ? OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.truefullbright.step.tooltip")}) : OptionDescription.of((class_2561[])new class_2561[0])).binding((Object)1.0, () -> config.step, val -> {
                config.step = Math.max(0.1, Math.min(100.0, val));
                config.markDirty();
            }).controller(opt -> ((DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)0.1, (Number)100.0)).step((Number)0.1)).formatValue(v -> class_2561.method_43470((String)String.format("%.1f", v)))).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.min")).description(showTips ? OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.truefullbright.min.tooltip")}) : OptionDescription.of((class_2561[])new class_2561[0])).binding((Object)0.0, () -> config.minBrightness, val -> {
                config.minBrightness = Math.max(0.0, Math.min(100.0, val));
                if (config.minBrightness > config.maxBrightness) {
                    config.maxBrightness = config.minBrightness + 1.0;
                }
                config.markDirty();
            }).controller(opt -> ((DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)0.0, (Number)100.0)).step((Number)0.1)).formatValue(v -> class_2561.method_43470((String)String.format("%.1f", v)))).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.max")).description(showTips ? OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.truefullbright.max.tooltip")}) : OptionDescription.of((class_2561[])new class_2561[0])).binding((Object)100.0, () -> config.maxBrightness, val -> {
                config.maxBrightness = Math.max(1.0, Math.min(100.0, val));
                if (config.maxBrightness < config.minBrightness) {
                    config.minBrightness = config.maxBrightness - 1.0;
                }
                config.markDirty();
            }).controller(opt -> ((DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)1.0, (Number)100.0)).step((Number)0.1)).formatValue(v -> class_2561.method_43470((String)String.format("%.1f", v)))).build()).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.category.info")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.show_tooltips")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.truefullbright.show_tooltips.tooltip")})).binding((Object)true, () -> config.showTooltips, val -> {
                config.showTooltips = val;
                config.markDirty();
            }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.current_status")).description(showTips ? OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.truefullbright.current_status.tooltip")}) : OptionDescription.of((class_2561[])new class_2561[0])).binding((Object)"", () -> FullbrightConfigScreen.getCurrentStatusString(config), val -> {}).controller(StringControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.truefullbright.keybinds_info")).description(showTips ? OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.truefullbright.keybinds_info.tooltip")}) : OptionDescription.of((class_2561[])new class_2561[0])).binding((Object)"", () -> "Check Controls > Key Binds > True Fullbright", val -> {}).controller(StringControllerBuilder::create).build()).build()).save(() -> {
                try {
                    FullbrightConfig.save();
                    LOGGER.info("Configuration saved successfully");
                }
                catch (Exception e) {
                    LOGGER.error("Failed to save configuration", (Throwable)e);
                }
            }).build().generateScreen(parent);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create config screen", (Throwable)e);
            return parent;
        }
    }

    private static String getCurrentStatusString(FullbrightConfig config) {
        StringBuilder status = new StringBuilder();
        if (config.useGamma) {
            status.append("\u00a7aON\u00a7r - Gamma Mode (").append(String.format("%.1f", config.brightness)).append(")");
        } else if (config.useNightVision) {
            status.append("\u00a7aON\u00a7r - Night Vision Mode");
        } else {
            status.append("\u00a7cOFF\u00a7r - Disabled");
        }
        return status.toString();
    }
}

