/*
 * Decompiled with CFR 0.152.
 */
package com.improvedf3.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "improvedf3.json");
    private static ModConfig INSTANCE = new ModConfig();
    public String language = "en_us";
    public boolean showBackground = true;
    public boolean showMinecraftVersion = true;
    public boolean showFPS = true;
    public boolean showCoordinates = true;
    public boolean showBlock = true;
    public boolean showChunk = true;
    public boolean showFacing = true;
    public boolean showBiome = true;
    public boolean showJava = true;
    public boolean showMemory = true;
    public boolean showAllocated = true;
    public boolean showCPU = true;
    public boolean showDisplay = true;
    public boolean showLightLevel = true;
    public boolean showTime = true;
    public boolean showWeather = true;
    public boolean showEntityCount = true;
    public boolean showPing = true;
    public boolean showTPS = true;
    public boolean showWorldName = true;
    public boolean showDifficulty = true;

    public static ModConfig getInstance() {
        return INSTANCE;
    }

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                INSTANCE = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                if (INSTANCE == null) {
                    INSTANCE = new ModConfig();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

