/*
 * Decompiled with CFR 0.152.
 */
package com.improvedf3.util;

import com.improvedf3.config.ModConfig;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TranslationHelper {
    private static final Map<String, Map<String, String>> TRANSLATIONS = new HashMap<String, Map<String, String>>();

    public static String translate(String key) {
        String lang = ModConfig.getInstance().language;
        Map<String, String> langMap = TRANSLATIONS.get(lang);
        if (langMap == null) {
            langMap = TRANSLATIONS.get("en_us");
        }
        return langMap.getOrDefault(key.toLowerCase(), key);
    }

    public static String translateBiome(String biomeId) {
        String biomeName = biomeId.contains(":") ? biomeId.split(":")[1] : biomeId;
        String translated = TranslationHelper.translate("biome." + biomeName);
        if (translated.equals("biome." + biomeName)) {
            return biomeName.replace("_", " ");
        }
        return translated;
    }

    static {
        HashMap<String, String> en = new HashMap<String, String>();
        en.put("minecraft", "Minecraft");
        en.put("fps", "fps");
        en.put("xyz", "XYZ");
        en.put("block", "Block");
        en.put("chunk", "Chunk");
        en.put("facing", "Facing");
        en.put("biome", "Biome");
        en.put("java", "Java");
        en.put("memory", "Memory");
        en.put("allocated", "Allocated");
        en.put("cpu", "CPU");
        en.put("display", "Display");
        en.put("cores", "cores");
        en.put("light", "Light");
        en.put("time", "Time");
        en.put("weather", "Weather");
        en.put("entities", "Entities");
        en.put("ping", "Ping");
        en.put("tps", "TPS");
        en.put("world", "World");
        en.put("difficulty", "Difficulty");
        en.put("weather.clear", "Clear");
        en.put("weather.rain", "Rain");
        en.put("weather.thunder", "Thunder");
        en.put("difficulty.peaceful", "Peaceful");
        en.put("difficulty.easy", "Easy");
        en.put("difficulty.normal", "Normal");
        en.put("difficulty.hard", "Hard");
        en.put("north", "North");
        en.put("south", "South");
        en.put("east", "East");
        en.put("west", "West");
        en.put("up", "Up");
        en.put("down", "Down");
        TRANSLATIONS.put("en_us", en);
        HashMap<String, String> de = new HashMap<String, String>();
        de.put("minecraft", "Minecraft");
        de.put("fps", "FPS");
        de.put("xyz", "XYZ");
        de.put("block", "Block");
        de.put("chunk", "Chunk");
        de.put("facing", "Richtung");
        de.put("biome", "Biom");
        de.put("java", "Java");
        de.put("memory", "Speicher");
        de.put("allocated", "Zugewiesen");
        de.put("cpu", "CPU");
        de.put("display", "Anzeige");
        de.put("cores", "Kerne");
        de.put("light", "Licht");
        de.put("time", "Zeit");
        de.put("weather", "Wetter");
        de.put("entities", "Entit\u00e4ten");
        de.put("ping", "Ping");
        de.put("tps", "TPS");
        de.put("world", "Welt");
        de.put("difficulty", "Schwierigkeit");
        de.put("weather.clear", "Klar");
        de.put("weather.rain", "Regen");
        de.put("weather.thunder", "Gewitter");
        de.put("difficulty.peaceful", "Friedlich");
        de.put("difficulty.easy", "Einfach");
        de.put("difficulty.normal", "Normal");
        de.put("difficulty.hard", "Schwer");
        de.put("north", "Norden");
        de.put("south", "S\u00fcden");
        de.put("east", "Osten");
        de.put("west", "Westen");
        de.put("up", "Hoch");
        de.put("down", "Runter");
        TRANSLATIONS.put("de_de", de);
        HashMap<String, String> pl = new HashMap<String, String>();
        pl.put("minecraft", "Minecraft");
        pl.put("fps", "FPS");
        pl.put("xyz", "XYZ");
        pl.put("block", "Blok");
        pl.put("chunk", "Chunk");
        pl.put("facing", "Kierunek");
        pl.put("biome", "Biom");
        pl.put("java", "Java");
        pl.put("memory", "Pami\u0119\u0107");
        pl.put("allocated", "Przydzielono");
        pl.put("cpu", "CPU");
        pl.put("display", "Wy\u015bwietlacz");
        pl.put("cores", "rdzenie");
        pl.put("light", "\u015awiat\u0142o");
        pl.put("time", "Czas");
        pl.put("weather", "Pogoda");
        pl.put("entities", "Encje");
        pl.put("ping", "Ping");
        pl.put("tps", "TPS");
        pl.put("world", "\u015awiat");
        pl.put("difficulty", "Trudno\u015b\u0107");
        pl.put("weather.clear", "Czysto");
        pl.put("weather.rain", "Deszcz");
        pl.put("weather.thunder", "Burza");
        pl.put("difficulty.peaceful", "Pokojowy");
        pl.put("difficulty.easy", "\u0141atwy");
        pl.put("difficulty.normal", "Normalny");
        pl.put("difficulty.hard", "Trudny");
        pl.put("north", "P\u00f3\u0142noc");
        pl.put("south", "Po\u0142udnie");
        pl.put("east", "Wsch\u00f3d");
        pl.put("west", "Zach\u00f3d");
        pl.put("up", "G\u00f3ra");
        pl.put("down", "D\u00f3\u0142");
        TRANSLATIONS.put("pl_pl", pl);
        HashMap<String, String> uk = new HashMap<String, String>();
        uk.put("minecraft", "Minecraft");
        uk.put("fps", "FPS");
        uk.put("xyz", "XYZ");
        uk.put("block", "\u0411\u043b\u043e\u043a");
        uk.put("chunk", "\u0427\u0430\u043d\u043a");
        uk.put("facing", "\u041d\u0430\u043f\u0440\u044f\u043c\u043e\u043a");
        uk.put("biome", "\u0411\u0456\u043e\u043c");
        uk.put("java", "Java");
        uk.put("memory", "\u041f\u0430\u043c'\u044f\u0442\u044c");
        uk.put("allocated", "\u0412\u0438\u0434\u0456\u043b\u0435\u043d\u043e");
        uk.put("cpu", "CPU");
        uk.put("display", "\u0414\u0438\u0441\u043f\u043b\u0435\u0439");
        uk.put("cores", "\u044f\u0434\u0440\u0430");
        uk.put("light", "\u0421\u0432\u0456\u0442\u043b\u043e");
        uk.put("time", "\u0427\u0430\u0441");
        uk.put("weather", "\u041f\u043e\u0433\u043e\u0434\u0430");
        uk.put("entities", "\u0421\u0443\u0442\u043d\u043e\u0441\u0442\u0456");
        uk.put("ping", "\u041f\u0456\u043d\u0433");
        uk.put("tps", "TPS");
        uk.put("world", "\u0421\u0432\u0456\u0442");
        uk.put("difficulty", "\u0421\u043a\u043b\u0430\u0434\u043d\u0456\u0441\u0442\u044c");
        uk.put("weather.clear", "\u042f\u0441\u043d\u043e");
        uk.put("weather.rain", "\u0414\u043e\u0449");
        uk.put("weather.thunder", "\u0413\u0440\u043e\u0437\u0430");
        uk.put("difficulty.peaceful", "\u041c\u0438\u0440\u043d\u0438\u0439");
        uk.put("difficulty.easy", "\u041b\u0435\u0433\u043a\u0438\u0439");
        uk.put("difficulty.normal", "\u041d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u0438\u0439");
        uk.put("difficulty.hard", "\u0412\u0430\u0436\u043a\u0438\u0439");
        uk.put("north", "\u041f\u0456\u0432\u043d\u0456\u0447");
        uk.put("south", "\u041f\u0456\u0432\u0434\u0435\u043d\u044c");
        uk.put("east", "\u0421\u0445\u0456\u0434");
        uk.put("west", "\u0417\u0430\u0445\u0456\u0434");
        uk.put("up", "\u0412\u0433\u043e\u0440\u0443");
        uk.put("down", "\u0412\u043d\u0438\u0437");
        TRANSLATIONS.put("uk_ua", uk);
        HashMap<String, String> ru = new HashMap<String, String>();
        ru.put("minecraft", "Minecraft");
        ru.put("fps", "FPS");
        ru.put("xyz", "XYZ");
        ru.put("block", "\u0411\u043b\u043e\u043a");
        ru.put("chunk", "\u0427\u0430\u043d\u043a");
        ru.put("facing", "\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435");
        ru.put("biome", "\u0411\u0438\u043e\u043c");
        ru.put("java", "Java");
        ru.put("memory", "\u041f\u0430\u043c\u044f\u0442\u044c");
        ru.put("allocated", "\u0412\u044b\u0434\u0435\u043b\u0435\u043d\u043e");
        ru.put("cpu", "CPU");
        ru.put("display", "\u0414\u0438\u0441\u043f\u043b\u0435\u0439");
        ru.put("cores", "\u044f\u0434\u0440\u0430");
        ru.put("light", "\u0421\u0432\u0435\u0442");
        ru.put("time", "\u0412\u0440\u0435\u043c\u044f");
        ru.put("weather", "\u041f\u043e\u0433\u043e\u0434\u0430");
        ru.put("entities", "\u0421\u0443\u0449\u043d\u043e\u0441\u0442\u0438");
        ru.put("ping", "\u041f\u0438\u043d\u0433");
        ru.put("tps", "TPS");
        ru.put("world", "\u041c\u0438\u0440");
        ru.put("difficulty", "\u0421\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c");
        ru.put("weather.clear", "\u042f\u0441\u043d\u043e");
        ru.put("weather.rain", "\u0414\u043e\u0436\u0434\u044c");
        ru.put("weather.thunder", "\u0413\u0440\u043e\u0437\u0430");
        ru.put("difficulty.peaceful", "\u041c\u0438\u0440\u043d\u044b\u0439");
        ru.put("difficulty.easy", "\u041b\u0451\u0433\u043a\u0438\u0439");
        ru.put("difficulty.normal", "\u041e\u0431\u044b\u0447\u043d\u044b\u0439");
        ru.put("difficulty.hard", "\u0421\u043b\u043e\u0436\u043d\u044b\u0439");
        ru.put("north", "\u0421\u0435\u0432\u0435\u0440");
        ru.put("south", "\u042e\u0433");
        ru.put("east", "\u0412\u043e\u0441\u0442\u043e\u043a");
        ru.put("west", "\u0417\u0430\u043f\u0430\u0434");
        ru.put("up", "\u0412\u0432\u0435\u0440\u0445");
        ru.put("down", "\u0412\u043d\u0438\u0437");
        TRANSLATIONS.put("ru_ru", ru);
        HashMap<String, String> tr = new HashMap<String, String>();
        tr.put("minecraft", "Minecraft");
        tr.put("fps", "FPS");
        tr.put("xyz", "XYZ");
        tr.put("block", "Blok");
        tr.put("chunk", "Chunk");
        tr.put("facing", "Y\u00f6n");
        tr.put("biome", "Biyom");
        tr.put("java", "Java");
        tr.put("memory", "Bellek");
        tr.put("allocated", "Ayr\u0131lm\u0131\u015f");
        tr.put("cpu", "CPU");
        tr.put("display", "Ekran");
        tr.put("cores", "\u00e7ekirdek");
        tr.put("light", "I\u015f\u0131k");
        tr.put("time", "Zaman");
        tr.put("weather", "Hava");
        tr.put("entities", "Varl\u0131klar");
        tr.put("ping", "Ping");
        tr.put("tps", "TPS");
        tr.put("world", "D\u00fcnya");
        tr.put("difficulty", "Zorluk");
        tr.put("weather.clear", "A\u00e7\u0131k");
        tr.put("weather.rain", "Ya\u011fmur");
        tr.put("weather.thunder", "F\u0131rt\u0131na");
        tr.put("difficulty.peaceful", "Bar\u0131\u015f\u00e7\u0131l");
        tr.put("difficulty.easy", "Kolay");
        tr.put("difficulty.normal", "Normal");
        tr.put("difficulty.hard", "Zor");
        tr.put("north", "Kuzey");
        tr.put("south", "G\u00fcney");
        tr.put("east", "Do\u011fu");
        tr.put("west", "Bat\u0131");
        tr.put("up", "Yukar\u0131");
        tr.put("down", "A\u015fa\u011f\u0131");
        TRANSLATIONS.put("tr_tr", tr);
        HashMap<String, String> hi = new HashMap<String, String>();
        hi.put("minecraft", "Minecraft");
        hi.put("fps", "FPS");
        hi.put("xyz", "XYZ");
        hi.put("block", "\u092c\u094d\u0932\u0949\u0915");
        hi.put("chunk", "\u091a\u0902\u0915");
        hi.put("facing", "\u0926\u093f\u0936\u093e");
        hi.put("biome", "\u092c\u093e\u092f\u094b\u092e");
        hi.put("java", "Java");
        hi.put("memory", "\u092e\u0947\u092e\u094b\u0930\u0940");
        hi.put("allocated", "\u0906\u0935\u0902\u091f\u093f\u0924");
        hi.put("cpu", "CPU");
        hi.put("display", "\u0921\u093f\u0938\u094d\u092a\u094d\u0932\u0947");
        hi.put("cores", "\u0915\u094b\u0930");
        hi.put("light", "\u092a\u094d\u0930\u0915\u093e\u0936");
        hi.put("time", "\u0938\u092e\u092f");
        hi.put("weather", "\u092e\u094c\u0938\u092e");
        hi.put("entities", "\u0907\u0915\u093e\u0907\u092f\u093e\u0902");
        hi.put("ping", "\u092a\u093f\u0902\u0917");
        hi.put("tps", "TPS");
        hi.put("world", "\u0926\u0941\u0928\u093f\u092f\u093e");
        hi.put("difficulty", "\u0915\u0920\u093f\u0928\u093e\u0908");
        hi.put("weather.clear", "\u0938\u093e\u092b");
        hi.put("weather.rain", "\u092c\u093e\u0930\u093f\u0936");
        hi.put("weather.thunder", "\u0924\u0942\u092b\u093e\u0928");
        hi.put("difficulty.peaceful", "\u0936\u093e\u0902\u0924\u093f\u092a\u0942\u0930\u094d\u0923");
        hi.put("difficulty.easy", "\u0906\u0938\u093e\u0928");
        hi.put("difficulty.normal", "\u0938\u093e\u092e\u093e\u0928\u094d\u092f");
        hi.put("difficulty.hard", "\u0915\u0920\u093f\u0928");
        hi.put("north", "\u0909\u0924\u094d\u0924\u0930");
        hi.put("south", "\u0926\u0915\u094d\u0937\u093f\u0923");
        hi.put("east", "\u092a\u0942\u0930\u094d\u0935");
        hi.put("west", "\u092a\u0936\u094d\u091a\u093f\u092e");
        hi.put("up", "\u090a\u092a\u0930");
        hi.put("down", "\u0928\u0940\u091a\u0947");
        TRANSLATIONS.put("hi_in", hi);
        HashMap<String, String> zh = new HashMap<String, String>();
        zh.put("minecraft", "Minecraft");
        zh.put("fps", "\u5e27\u7387");
        zh.put("xyz", "XYZ");
        zh.put("block", "\u65b9\u5757");
        zh.put("chunk", "\u533a\u5757");
        zh.put("facing", "\u671d\u5411");
        zh.put("biome", "\u751f\u7269\u7fa4\u7cfb");
        zh.put("java", "Java");
        zh.put("memory", "\u5185\u5b58");
        zh.put("allocated", "\u5df2\u5206\u914d");
        zh.put("cpu", "CPU");
        zh.put("display", "\u663e\u793a");
        zh.put("cores", "\u6838\u5fc3");
        zh.put("light", "\u5149\u7167");
        zh.put("time", "\u65f6\u95f4");
        zh.put("weather", "\u5929\u6c14");
        zh.put("entities", "\u5b9e\u4f53");
        zh.put("ping", "\u5ef6\u8fdf");
        zh.put("tps", "TPS");
        zh.put("world", "\u4e16\u754c");
        zh.put("difficulty", "\u96be\u5ea6");
        zh.put("weather.clear", "\u6674\u6717");
        zh.put("weather.rain", "\u4e0b\u96e8");
        zh.put("weather.thunder", "\u96f7\u66b4");
        zh.put("difficulty.peaceful", "\u548c\u5e73");
        zh.put("difficulty.easy", "\u7b80\u5355");
        zh.put("difficulty.normal", "\u666e\u901a");
        zh.put("difficulty.hard", "\u56f0\u96be");
        zh.put("north", "\u5317");
        zh.put("south", "\u5357");
        zh.put("east", "\u4e1c");
        zh.put("west", "\u897f");
        zh.put("up", "\u4e0a");
        zh.put("down", "\u4e0b");
        TRANSLATIONS.put("zh_cn", zh);
        HashMap<String, String> es = new HashMap<String, String>();
        es.put("minecraft", "Minecraft");
        es.put("fps", "FPS");
        es.put("xyz", "XYZ");
        es.put("block", "Bloque");
        es.put("chunk", "Chunk");
        es.put("facing", "Direcci\u00f3n");
        es.put("biome", "Bioma");
        es.put("java", "Java");
        es.put("memory", "Memoria");
        es.put("allocated", "Asignado");
        es.put("cpu", "CPU");
        es.put("display", "Pantalla");
        es.put("cores", "n\u00facleos");
        es.put("light", "Luz");
        es.put("time", "Tiempo");
        es.put("weather", "Clima");
        es.put("entities", "Entidades");
        es.put("ping", "Ping");
        es.put("tps", "TPS");
        es.put("world", "Mundo");
        es.put("difficulty", "Dificultad");
        es.put("weather.clear", "Despejado");
        es.put("weather.rain", "Lluvia");
        es.put("weather.thunder", "Tormenta");
        es.put("difficulty.peaceful", "Pac\u00edfico");
        es.put("difficulty.easy", "F\u00e1cil");
        es.put("difficulty.normal", "Normal");
        es.put("difficulty.hard", "Dif\u00edcil");
        es.put("north", "Norte");
        es.put("south", "Sur");
        es.put("east", "Este");
        es.put("west", "Oeste");
        es.put("up", "Arriba");
        es.put("down", "Abajo");
        TRANSLATIONS.put("es_es", es);
    }
}

