/*
 * Decompiled with CFR 0.152.
 */
package com.improvedf3.mixin.client;

import com.improvedf3.config.ModConfig;
import com.improvedf3.util.TranslationHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_340;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_340.class})
public abstract class DebugHudMixin {
    @Shadow
    @Final
    private class_310 field_2079;
    @Shadow
    @Final
    private class_327 field_2081;

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderImprovedF3(class_332 context, CallbackInfo ci) {
        List<class_2561> leftLines = this.getImprovedLeftText();
        this.renderPanel(context, leftLines, true);
        List<class_2561> rightLines = this.getImprovedRightText();
        this.renderPanel(context, rightLines, false);
        ci.cancel();
    }

    private void renderPanel(class_332 context, List<class_2561> lines, boolean isLeft) {
        if (lines.isEmpty()) {
            return;
        }
        int maxWidth = 0;
        class_327 tr = this.field_2079.field_1772;
        for (class_2561 line : lines) {
            int width = this.field_2081.method_27525((class_5348)line);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        int padding = 4;
        int lineHeight = 9;
        int panelWidth = maxWidth + padding * 2;
        int panelHeight = lines.size() * lineHeight + padding * 2;
        int x = isLeft ? 2 : this.field_2079.method_22683().method_4486() - panelWidth - 2;
        int y = 2;
        if (ModConfig.getInstance().showBackground) {
            int opacity = (int)((double)ModConfig.getInstance().backgroundOpacity * 2.55);
            int color = opacity << 24 | 0;
            context.method_25294(x, y, x + panelWidth, y + panelHeight, color);
        }
        int currentY = y + padding;
        for (class_2561 line : lines) {
            context.method_51439(tr, line, x + padding, currentY, -1, false);
            currentY += lineHeight;
        }
    }

    private List<class_2561> getImprovedLeftText() {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        ModConfig config = ModConfig.getInstance();
        if (config.showMinecraftVersion) {
            lines.add((class_2561)class_2561.method_43470((String)(TranslationHelper.translate("minecraft") + " ")).method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)this.field_2079.method_1515()).method_27692(class_124.field_1068)));
        }
        if (config.showFPS) {
            int fps = this.field_2079.method_47599();
            class_124 fpsColor = fps >= 60 ? class_124.field_1060 : (fps >= 30 ? class_124.field_1054 : class_124.field_1061);
            lines.add((class_2561)class_2561.method_43470((String)(fps + " " + TranslationHelper.translate("fps"))).method_27692(fpsColor));
        }
        if (this.field_2079.field_1724 != null) {
            int blockX;
            double x = this.field_2079.field_1724.method_23317();
            double y = this.field_2079.field_1724.method_23318();
            double z = this.field_2079.field_1724.method_23321();
            if (config.showCoordinates) {
                lines.add((class_2561)class_2561.method_43473());
                lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("xyz")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)":").method_27692(class_124.field_1080)));
                lines.add((class_2561)class_2561.method_43470((String)String.format("  %.3f / %.3f / %.3f", x, y, z)).method_27692(class_124.field_1060));
            }
            if (config.showBlock) {
                blockX = (int)Math.floor(x);
                int blockY = (int)Math.floor(y);
                int blockZ = (int)Math.floor(z);
                lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("block")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(blockX + " " + blockY + " " + blockZ)).method_27692(class_124.field_1068)));
            }
            if (config.showChunk) {
                blockX = (int)Math.floor(x);
                int blockZ = (int)Math.floor(z);
                int chunkX = blockX >> 4;
                int chunkZ = blockZ >> 4;
                lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("chunk")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(chunkX + " " + chunkZ)).method_27692(class_124.field_1068)));
            }
            if (config.showFacing) {
                String direction = this.field_2079.field_1724.method_5735().toString().toLowerCase();
                String translatedDirection = TranslationHelper.translate(direction);
                lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("facing")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)translatedDirection).method_27692(class_124.field_1054)));
            }
            if (config.showBiome && this.field_2079.field_1687 != null) {
                String biome = this.field_2079.field_1687.method_23753(this.field_2079.field_1724.method_24515()).method_55840();
                String translatedBiome = TranslationHelper.translateBiome(biome);
                lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("biome")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)translatedBiome).method_27692(class_124.field_1054)));
            }
            if (config.showLightLevel && this.field_2079.field_1687 != null) {
                int lightLevel = this.field_2079.field_1687.method_22339(this.field_2079.field_1724.method_24515());
                class_124 lightColor = lightLevel >= 8 ? class_124.field_1060 : (lightLevel >= 4 ? class_124.field_1054 : class_124.field_1061);
                lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("light")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(lightLevel)).method_27692(lightColor)));
            }
            if (config.showTime && this.field_2079.field_1687 != null) {
                long time = this.field_2079.field_1687.method_8532();
                long day = time / 24000L;
                long timeOfDay = time % 24000L;
                int hours = (int)(timeOfDay / 1000L);
                int minutes = (int)(timeOfDay % 1000L * 60L / 1000L);
                String timeString = String.format("%02d:%02d", hours, minutes);
                lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("time")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("Day " + day + " " + timeString)).method_27692(class_124.field_1068)));
            }
            if (config.showWeather && this.field_2079.field_1687 != null) {
                String weatherKey = "weather.clear";
                if (this.field_2079.field_1687.method_8419()) {
                    weatherKey = this.field_2079.field_1687.method_8546() ? "weather.thunder" : "weather.rain";
                }
                String weather = TranslationHelper.translate(weatherKey);
                class_124 weatherColor = weatherKey.equals("weather.clear") ? class_124.field_1060 : (weatherKey.equals("weather.rain") ? class_124.field_1078 : class_124.field_1064);
                lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("weather")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)weather).method_27692(weatherColor)));
            }
            if (config.showWorldName && this.field_2079.field_1687 != null) {
                String worldName = this.field_2079.field_1687.method_27983().method_29177().toString();
                lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("world")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)worldName).method_27692(class_124.field_1068)));
            }
            if (config.showDifficulty && this.field_2079.field_1687 != null) {
                String difficultyKey = "difficulty." + this.field_2079.field_1687.method_8407().name().toLowerCase();
                String difficulty = TranslationHelper.translate(difficultyKey);
                lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("difficulty")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)difficulty).method_27692(class_124.field_1068)));
            }
        }
        return lines;
    }

    private List<class_2561> getImprovedRightText() {
        class_640 playerListEntry;
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        ModConfig config = ModConfig.getInstance();
        if (config.showJava) {
            lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("java")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)System.getProperty("java.version")).method_27692(class_124.field_1068)));
        }
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        int usedMb = (int)(usedMemory / 1024L / 1024L);
        int maxMb = (int)(maxMemory / 1024L / 1024L);
        if (config.showMemory) {
            lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("memory")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(usedMb + "MB / " + maxMb + "MB")).method_27692(class_124.field_1076)));
        }
        if (config.showAllocated) {
            int allocatedMb = (int)(totalMemory / 1024L / 1024L);
            lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("allocated")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(allocatedMb + "MB")).method_27692(class_124.field_1076)));
        }
        if (config.showCPU) {
            lines.add((class_2561)class_2561.method_43473());
            lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("cpu")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(Runtime.getRuntime().availableProcessors() + " " + TranslationHelper.translate("cores"))).method_27692(class_124.field_1068)));
        }
        if (config.showDisplay && this.field_2079.method_22683() != null) {
            int width = this.field_2079.method_22683().method_4489();
            int height = this.field_2079.method_22683().method_4506();
            lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("display")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(width + "x" + height)).method_27692(class_124.field_1068)));
        }
        if (config.showEntityCount && this.field_2079.field_1687 != null) {
            int entityCount = 0;
            for (class_1297 entity : this.field_2079.field_1687.method_18112()) {
                ++entityCount;
            }
            lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("entities")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(entityCount)).method_27692(class_124.field_1068)));
        }
        if (config.showPing && this.field_2079.method_1562() != null && this.field_2079.field_1724 != null && (playerListEntry = this.field_2079.method_1562().method_2871(this.field_2079.field_1724.method_5667())) != null) {
            int ping = playerListEntry.method_2959();
            class_124 pingColor = ping < 50 ? class_124.field_1060 : (ping < 150 ? class_124.field_1054 : class_124.field_1061);
            lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("ping")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(ping + "ms")).method_27692(pingColor)));
        }
        if (config.showTPS && this.field_2079.field_1687 != null) {
            lines.add((class_2561)class_2561.method_43470((String)TranslationHelper.translate("tps")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"N/A").method_27692(class_124.field_1080)));
        }
        return lines;
    }
}

